/*
	Sunrise Calculator - A Sunrise and Sunset Calculator
	Copyright © 2006-2015 Harry Whitfield

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2 of the License, or (at your
	option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

	Sunrise Calculator - browser version 1.0
	30 April, 2015
	Copyright © 2006-2015 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*global setToday */

/*properties
    PI, add, appendChild, background, backgroundColor, body, border, clearRect,
    clientX, close, cols, createElement, ctx, div, drawImage, getContext,
    hOffset, hRegP, height, hoffset, left, length, maxWidth, onclick,
    onmousedown, onmousemove, onmouseout, onmouseover, onmouseup, opacity, open,
    readonly, restore, rotate, round, rows, save, scale, selectedIndex,
    setAttribute, setStyle, size, src, style, text, title, top, tracking,
    translate, type, vRegP, value, width, zOrder
*/

//////////////////////////////////////////////////////////////////////////////////////////

var scale = 1.0, vtop = 0, left = 0, fScale = 6.67;

var main_window = {width: Math.round(280 * scale), height: Math.round(318 * scale)},
	halfWidth   = Math.round(main_window.width  / 2),
	halfHeight  = Math.round(main_window.height / 2),
	
	radToDeg = 180 / Math.PI,
	degToRad = Math.PI / 180,
	rotToPc  = 100 / 360;

function newElement(tagName, hOffset, vOffset, zOrder) {
	var div = document.createElement("div"), ele;

	div.setAttribute("style", "position: absolute; left: " + String(hOffset + left) +
		"px; top: " + String(vOffset + vtop) + "px; z-index: " + String(zOrder) + ";");

	document.body.appendChild(div);
		
	ele = document.createElement(tagName);
	ele.left = hOffset;
	ele.top  = vOffset;
	ele.div = div;
	ele.zOrder = zOrder;
	div.appendChild(ele);

	return ele;
}

function moveImg(obj, hOffset, vOffset) {
	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);

	obj.div.setAttribute("style", "position: absolute; left: " + String(hOffset + left) +
		"px; top: " + String(vOffset + vtop) + "px; z-index: " + String(obj.zOrder) + ";");
}

function move(obj) {
	obj.div.setAttribute("style", "position: absolute; left: " + String(obj.left + left) +
		"px; top: " + String(obj.top + vtop) + "px; z-index: " + String(obj.zOrder) + ";");
}

function newImage(hOffset, vOffset, width, height, src, zOrder, opacity) {
	var img;

	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);
	
	img = newElement("img", hOffset, vOffset, zOrder);
	
	img.width  = Math.round(scale * width);
	img.height = Math.round(scale * height);
	img.src = src;
	img.style.opacity = opacity || 1.0;
	return img;
}

function newCanvas(hOffset, vOffset, width, height, src, zOrder, opacity, hRegP, vRegP) {
	var canvas;
	
	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);
	
	canvas = newElement("canvas", hOffset, vOffset, zOrder);

	hRegP = hRegP || 0;		// hRegP and vRegP are optional parameters
	vRegP = vRegP || 0;

	canvas.src = src;
	canvas.style.opacity = opacity || 1.0;
	
	canvas.width = Math.round(scale * width);
	canvas.height = Math.round(scale * height);
	canvas.ctx = canvas.getContext("2d");
	canvas.hRegP = Math.round(scale * hRegP);
	canvas.vRegP = Math.round(scale * vRegP);
	return canvas;
}

function newCanvasImage(canvas) {
	var img = new Image();
	
	img.width  = canvas.width;
	img.height = canvas.height;
	img.src    = canvas.src;
	return img;
}

function drawImage(canvas, img, hOff, vOff, ang) {
	var ctx = canvas.ctx, width = canvas.width, height = canvas.height,
		hRegP = canvas.hRegP, vRegP = canvas.vRegP;

	ctx.save();
	ctx.clearRect(0, 0, width, height);
	ctx.translate(hRegP, vRegP);
	ctx.rotate(Math.PI * ang / 180);
	ctx.translate(-hRegP, -vRegP);
	ctx.scale(scale, scale);
	ctx.drawImage(img, hOff, vOff);
	ctx.restore();
}
/*
function drawText(canvas, text, hOff, vOff, ang, font) {
	var ctx = canvas.ctx, width = canvas.width, height = canvas.height,
		hRegP = canvas.hRegP, vRegP = canvas.vRegP;
	
	ctx.save();
	ctx.clearRect(0, 0, width, height);
	ctx.translate(hRegP, vRegP);
	ctx.rotate(Math.PI * ang / 180);
	ctx.translate(-hRegP, -vRegP);
	ctx.scale(scale, scale);
	ctx.font = font;
	ctx.fillText(text, hOff, vOff); 
	ctx.restore();
}
*/

function newSelector(hOffset, vOffset, width, height, src, zOrder, opacity) {
	var selector;

	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);
	
	selector = newElement("select", hOffset, vOffset, zOrder);
	
	selector.width  = Math.round(scale * width);
	selector.height = Math.round(scale * height);
	selector.src = src;
	selector.style.opacity = opacity || 1.0;
	
//	selector.style.fontWeight = "bold";
//	selector.style.fontSize = "14px";
	
	return selector;
}

function addToMenu(selector, strings) {
	var i, option;

	for (i = 0; i < strings.length; i += 1) {
		option = document.createElement("option");
		option.text = strings[i];
		selector.add(option);
	}
}

function newInput(hOffset, vOffset, width, height, value, zOrder, opacity) {
	var input;

	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);
	
	input = newElement("input", hOffset, vOffset, zOrder);
	input.type = "text";
	
	input.width = Math.round(scale * width);
	input.size  = Math.round(scale * width / fScale);
	input.height = Math.round(scale * height);
	input.value = value;
	input.style.opacity = opacity || 1.0;
	return input;
}

function newTextArea(hOffset, vOffset, cols, rows, value, zOrder, readonly) {
	var textarea;

	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);
	
	textarea = newElement("textarea", hOffset, vOffset, zOrder);
	
	textarea.cols  = cols;
	textarea.rows  = rows;
	textarea.value = value;
	textarea.readonly = readonly;

	return textarea;
}

//////////////////////////////////////////////////////////////////////////////////////////

var base, leftTop, leftMid, leftLow, middleTop, middleMid, middleLow,
	rightTop, rightMid, rightLow, dragbox, redButton, amberButton, greenButton, title,
	leftBgOne, midBgOne, rightBgOne, leftBgTwo, midBgTwo, rightBgTwo,
	leftBgThree, midBgThree, rightBgThree, leftBgFour, midBgFour, rightBgFour,
	leftBgFive, midBgFive, rightBgFive, leftBgSix, midBgSix, rightBgSix,
	paramOne, paramTwo, paramThree, paramFour, paramFive, paramSix,
	headingOne, headingTwo, headingThree, headingFour, headingFive, headingSix,
	headingSeven, helpButton, font;

(function () {
//	mainWindow.width  = Math.round(scale * 280);
//	mainWindow.height = Math.round(scale * 318);

// newImage(hOffset, vOffset, width, height, src, zOrder, opacity) {
// newInput(hOffset, vOffset, size, height, value, zOrder, opacity) {
// newTextArea(hOffset, vOffset, cols, rows, value, zOrder, readonly) {
// newCanvas(hOffset, vOffset, width, height, src, zOrder, opacity, hRegP, vRegP)	

	base = "Resources/bkgd/";

	leftTop   = newImage(0,     0,  40,  40, base + "bgleftTop.png",     1);
	leftMid	  = newImage(0,    40,  40, 225, base + "bgleftMid.png",     1);
	leftLow	  = newImage(0,   265,  40,  53, base + "bgleftLow.png",     1);
	
	middleTop = newImage(40,    0, 200,  40, base + "bgmiddleTop.png",   1);
	middleMid = newImage(40,   40, 200, 225, base + "bgmiddleMid.png",   1);
	middleLow = newImage(40,  265, 200,  53, base + "bgmiddleLow.png",   1);
	
	rightTop  = newImage(240,   0,  40,  40, base + "bgrightTop.png",    1);
	rightMid  = newImage(240,  40,  40, 225, base + "bgrightMid.png",    1);
	rightLow  = newImage(240, 265,  40,  53, base + "bgrightLow.png",    1);
	
	dragbox   = newImage(238, 271,  20,  20, base + "dragbox.png",       2);
	dragbox.tracking = "rectangle";
	dragbox.title = "Click to enable - move over me to change the widget's width - click again to disable.";
	
	base = "Resources/buttons/";

	redButton   = newImage(28,     21, 21,  14, base + "red.png",     2);
	amberButton = newImage(49,     21, 21,  14, base + "amber.png",   2);
	greenButton = newImage(70,     21, 14,  14, base + "green.png",   2);
	
	helpButton  = newImage(413,    16, 30,  22, base + "help.png",    2);	// customized

	redButton.title   = "Close the Widget.";
	amberButton.title = "Calculate with today's date.";						// customized
//  amberButton.title = "Clear the data fields.";							// customized
	greenButton.title = "Toggle window size.";
	
	helpButton.title  = "Displays information about this program.";
	
	title = newInput(88, 18, 110, 16, "Sunrise Calculator", 2);	// customized
	title.style.backgroundColor = "transparent";
	title.style.border = "none";

	base = "Resources/boxes/";

	leftBgOne    = newImage(28,  44,  18, 39, base + "tbleft.png",    2);
	midBgOne     = newImage(46,  44, 188, 39, base + "tbmiddle.png",  2);
	rightBgOne   = newImage(234, 44,  18, 39, base + "tbright.png",   2);
	
	leftBgTwo    = newImage(28,  100,  18, 39, base + "tbleft.png",   2);
	midBgTwo     = newImage(46,  100, 188, 39, base + "tbmiddle.png", 2);
	rightBgTwo   = newImage(234, 100,  18, 39, base + "tbright.png",  2);
	
	leftBgThree  = newImage(28,  156,  18, 39, base + "tbleft.png",   2);
	midBgThree   = newImage(46,  156, 188, 39, base + "tbmiddle.png", 2);
	rightBgThree = newImage(234, 156,  18, 39, base + "tbright.png",  2);
	
	leftBgFour   = newImage(28,  212,  18, 39, base + "tbleft.png",   2);
	midBgFour    = newImage(46,  212, 188, 39, base + "tbmiddle.png", 2);
	rightBgFour  = newImage(234, 212,  18, 39, base + "tbright.png",  2);
	
	leftBgFive   = newImage(328,  44,  18, 39, base + "tbleft.png",   2);
	midBgFive    = newImage(346,  44,  83, 39, base + "tbmiddle.png", 2);
	rightBgFive  = newImage(429,  44,  18, 39, base + "tbright.png",  2);

	leftBgSix    = newImage(328, 100,  18, 39, base + "tbleft.png",   2);
	midBgSix     = newImage(346, 100,  83, 39, base + "tbmiddle.png", 2);
	rightBgSix   = newImage(429, 100,  18, 39, base + "tbright.png",  2);

	paramOne     = newInput(37,   53,  200, 20, "", 3);
	paramTwo     = newInput(37,  109,  200, 20, "", 3);
	paramThree   = newInput(37,  165,  200, 20, "", 3);
	paramFour    = newInput(37,  221,  200, 20, "", 3);
	paramFive    = newInput(337,  53,  95,  20, "", 3);
	paramSix     = newInput(337, 109,  95,  20, "", 3);

//	paramFour.style.background  = "rgba(192 ,192, 192, 1.0)";
//	paramFour.style.border  = "none";

	paramOne.title   = "Enter a latitude (dd mm ss.ssss N/S) in this box.";								// customized
	paramTwo.title   = "Enter a longitude (ddd mm ss.ssss E/W) in this box";							// customized
	paramThree.title = "Enter a date (from 1970/01/01 onwards) in this box, using yyyy/mm/dd format.";	// customized
	paramFour.title  = "Sunrise/Sunset.";																// customized
	paramFive.title  = "Enter the altitude to be used in the calculation.";								// customized
	paramSix.title   = "Enter the number of hours that the time zone differs from UTC(GMT)." +
		" Zones west of Greenwich take negative values." +
		" Offsets should be expressed in hours, with a decimal part, if need be.";						// customized

	font = 'font-family:Courier;font-weight:normal;font-size:14px';
	
	paramOne.style.setStyle(font);
	paramTwo.style.setStyle(font);
	paramThree.style.setStyle(font);
	paramFour.style.setStyle(font);
	paramFive.style.setStyle(font);
	paramSix.style.setStyle(font);
	
	paramOne.style.border    = "none";
	paramTwo.style.border    = "none";
	paramThree.style.border  = "none";
	paramFour.style.border   = "none";
	paramFive.style.border   = "none";
	paramSix.style.border    = "none";

	paramFive.style.maxWidth =
		paramSix.style.maxWidth = Math.round(scale * 90) + "px";

	headingOne   = newInput(36,   74,  55, 16, "Latitude",        2);	// customized
	headingTwo   = newInput(36,  130,  60, 16, "Longitude",       2);	// customized
	headingThree = newInput(36,  186,  35, 16, "Date",            2);	// customized
	headingFour  = newInput(36,  242,  95, 16, "Sunrise/Sunset",  2);	// customized
	headingFive  = newInput(337,  74,  55, 16, "Altitude",        2);	// customized
	headingSix   = newInput(337, 130,  95, 16, "Timezone Offset", 2);	// customized
	headingSeven = newInput(265, 242,  105, 16, "Moonrise/Moonset",  2);	// customized

	headingOne.style.backgroundColor   = "transparent";
	headingTwo.style.backgroundColor   = "transparent";
	headingThree.style.backgroundColor = "transparent";
	headingFour.style.backgroundColor  = "transparent";
	headingFive.style.backgroundColor  = "transparent";
	headingSix.style.backgroundColor   = "transparent";
	headingSeven.style.backgroundColor = "transparent";

	headingOne.style.border   = "none";
	headingTwo.style.border   = "none";
	headingThree.style.border = "none";
	headingFour.style.border  = "none";
	headingFive.style.border  = "none";
	headingSix.style.border   = "none";
	headingSeven.style.border = "none";
}());

//////////////////////////////////// Menus Customized ////////////////////////////////////

var MenuArray = [
	['Official', 'Civil', 'Nautical', 'Astronomical'],
	['feet', 'metres'],
	['My Local Time', 'Universal Time', 'As given above']
];

var menuMap = [90.8333, 96, 102, 108];

var MenuTitleArray = [
	"Choose the type of sunrise/sunset calculation.",
	"Choose the units to be used for the altitude.",
	"Choose the timezone to be used for the display of sunrise and sunset times."
];

var MenuSelectedIndex = [0, 1, 1];

var Menu = [];

Menu[0] = newSelector(210,  17, 110, 20, "", 2);
Menu[1] = newSelector(340,  17,  56, 20, "", 2);
Menu[2] = newSelector(330, 165, 110, 20, "", 2);

var i;

for (i = 0; i < MenuArray.length; i += 1) {
	addToMenu(Menu[i],  MenuArray[i]);
	Menu[i].selectedIndex = MenuSelectedIndex[i];
	Menu[i].title = MenuTitleArray[i];
}

//////////////////////////////////////////////////////////////////////////////////////////

var print = function (s) { alert(s); };
var debug = false;
var minWidth = 300;		// customized
var maxWidth = 475;		// customized
var curWidth = maxWidth;
var dragEnabled = false;

function setUp(width) {
	if (debug) {
		print('setUp():======== start ========:');
		print('width=' + width);
		print('minWidth=' + minWidth);
		print('maxWidth=' + maxWidth);
	}

	if (width < minWidth) {
		width = minWidth;
	}
	if (width > maxWidth) {
		width = maxWidth;
	}

	main_window.width = width;
	
	middleTop.width  =
		middleMid.width  =
		middleLow.width  = width - 80;

	rightTop.hOffset = width - 40;
	moveImg(rightTop, width - 40,   0);
	moveImg(rightMid, width - 40,  40);
	moveImg(rightLow, width - 40, 265);

	midBgOne.width =
		midBgTwo.width =
		midBgThree.width = width - 212;
	midBgFour.width = width - 92;

	moveImg(rightBgOne,   width - 166,  44);
	moveImg(rightBgTwo,   width - 166, 100);
	moveImg(rightBgThree, width - 166, 156);
	moveImg(rightBgFour,  width -  46, 212);

	moveImg(leftBgFive,  width - 147,  44);
	moveImg(leftBgSix,   width - 147, 100);

	moveImg(midBgFive,  width - 131,  44);
	moveImg(midBgSix,   width - 131, 100);

	moveImg(rightBgFive,  width - 48,  44);
	moveImg(rightBgSix,   width - 48, 100);

	dragbox.hOffset = width - 42;
	moveImg(dragbox, width - 42,   271);
	
	paramOne.width =
		paramTwo.width =
		paramThree.width = Math.round(scale * (width - 200));
	paramFour.width  = Math.round(scale * (width - 80));
		
	paramFive.hOffset =
		paramSix.hOffset = Math.round(scale * (width - 139));
		
	moveImg(paramFive, width - 139,  53);
	moveImg(paramSix,  width - 139, 109);

	paramOne.size =
		paramTwo.size =
		paramThree.size = Math.round(scale * (width - 200) / fScale);
	paramFour.size = Math.round(scale * (width - 84) / fScale);

	paramOne.style.maxWidth =
		paramTwo.style.maxWidth =
		paramThree.style.maxWidth = Math.round(scale * (width - 204)) + "px";
	paramFour.style.maxWidth = Math.round(scale * (width - 84)) + "px";
	
	headingFive.hoffset    =
		headingSix.hoffset = width - 138;

	moveImg(headingFive, width - 138,   74);
	moveImg(headingSix,  width - 138,  130);

	if (debug) {
		print('width=' + width);

		print('main_window.width=' + main_window.width);
		print('middleTop.width='   + middleTop.width);
		print('rightTop.hOffset='  + rightTop.hOffset);
		print('paramOne.width='   + paramOne.width);
		print('dragbox.hOffset='  + dragbox.hOffset);

		print('setUp():========  end  ========:');
	}

	return width;
}

//////////////////////////////////////////////////////////////////////////////////////////

dragbox.onclick = function () {
	var i;
	
	dragEnabled = !dragEnabled;
	if (dragEnabled) {
		for (i = 0; i < MenuArray.length; i += 1) {
			Menu[i].style.opacity = 0.0;
		}
		helpButton.style.opacity = 0.0;
		headingSeven.style.opacity = 0.0;

	} else {
		if (curWidth === maxWidth) {
			for (i = 0; i < MenuArray.length; i += 1) {
				Menu[i].style.opacity = 1.0;
			}
			helpButton.style.opacity = 1.0;
			headingSeven.style.opacity = 1.0;
		}
	}
};

dragbox.onmousemove = function (event) {
	if (dragEnabled) {
		moveImg(dragbox, event.clientX - 10, 271);
		curWidth = setUp(event.clientX - 10 + 42);
	}
};

function normalButtons() {
	var base = "Resources/buttons/";
	
	redButton.src   = base + "red.png";
	amberButton.src = base + "amber.png";
	greenButton.src = base + "green.png";
}

function activeButtons() {
	var base = "Resources/buttons/";
	
	redButton.src   = base + "redCross.png";
	amberButton.src = base + "amberMinus.png";
	greenButton.src = base + "greenPlus.png";
}

redButton.onmouseover = function () {
	activeButtons();
};

redButton.onmouseout = function () {
	normalButtons();
};

amberButton.onmouseover = function () {
	activeButtons();
};

amberButton.onmouseout = function () {
	normalButtons();
};

greenButton.onmouseover = function () {
	activeButtons();
};

greenButton.onmouseout = function () {
	normalButtons();
};

redButton.onclick = function () {
	window.close();
};

function clearData() {
	paramOne.value =
		paramTwo.value =
		paramThree.value =
		paramFour.value = "";
}

amberButton.onclick = function () {
	setToday();
};

greenButton.onclick = function () {
	var i;
	
	dragEnabled = false;
	
	if (curWidth === minWidth) {
		curWidth = setUp(maxWidth);
		for (i = 0; i < MenuArray.length; i += 1) {
			Menu[i].style.opacity = 1.0;
		}
		helpButton.style.opacity   = 1.0;
		headingSeven.style.opacity = 1.0;
	} else {
		curWidth = setUp(minWidth);
		for (i = 0; i < MenuArray.length; i += 1) {
			Menu[i].style.opacity = 0.0;
		}
		helpButton.style.opacity   = 0.0;
		headingSeven.style.opacity = 0.0;
	}
};

helpButton.onmousedown = function () { this.style.opacity = "0.5"; };
helpButton.onmouseup   = function () { this.style.opacity = "1.0"; window.open("Help.html"); };

setUp(maxWidth);

