/*
	Traffic Light - browser version 1.2
	21 September, 2016
	Copyright 2012,2016 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*jslint browser */

/*global newImage */

/*property
    amber, back, green, index, onclick, opacity, red, setAspect, setIndex,
    setOnClick, setOpacity, setTooltip, style, title
*/

function Traffic_Light(hOffset, vOffset, zOrder) {
    "use strict";
	var	base = "Resources/Images/";
	var backBoard = base + "back.png";
	var redLamp = base + "red.png";
	var amberLamp = base + "amber.png";
	var greenLamp = base + "green.png";
	var o = {};

	o.back = newImage(hOffset, vOffset, 22, 69, backBoard, zOrder, 1.0);
	o.red = newImage(hOffset + 4, vOffset + 8, 14, 20, redLamp, zOrder + 1, 1.0);
	o.amber = newImage(hOffset + 4, vOffset + 28, 14, 20, amberLamp, zOrder + 1, 0.0);
	o.green = newImage(hOffset + 4, vOffset + 48, 14, 14, greenLamp, zOrder + 1, 1.0);

	o.setAspect = function (aspect) {
		o.red.style.opacity = 0;
		o.amber.style.opacity = 0;
		o.green.style.opacity = 0;

		switch (aspect) {
		case "off":				// 0
			break;
		case "green":			// 1
			o.green.style.opacity = 1;
			break;
		case "amber":			// 2
			o.amber.style.opacity = 1;
			break;
		case "amber_green":		// 3
			o.amber.style.opacity = 1;
			o.green.style.opacity = 1;
			break;
		case "red":				// 4
			o.red.style.opacity = 1;
			break;
		case "red_green":		// 5
			o.red.style.opacity = 1;
			o.green.style.opacity = 1;
			break;
		case "red_amber":		// 6
			o.red.style.opacity = 1;
			o.amber.style.opacity = 1;
			break;
		case "red_amber_green":	// 7
			o.red.style.opacity = 1;
			o.amber.style.opacity = 1;
			o.green.style.opacity = 1;
			break;
		}
	};

	o.setOpacity = function (lamp, opacity) {
		if ((lamp === "red") || (lamp === "amber") || (lamp === "green")) {
			o[lamp].style.opacity = opacity;
		}
	};

	o.setTooltip = function (lamp, tooltip) {
		if ((lamp === "red") || (lamp === "amber") || (lamp === "green")) {
			o[lamp].title = tooltip;
		}
	};

	o.setOnClick = function (lamp, action) {
		if ((lamp === "red") || (lamp === "amber") || (lamp === "green")) {
			o[lamp].onclick = action;
		}
	};

	o.setIndex = function (lamp, index) {
		if ((lamp === "red") || (lamp === "amber") || (lamp === "green")) {
			o[lamp].index = index;
		}
	};

	return o;
}
