/*
	Web Audio API
	Based on code samples from the page "Getting Started with Web Audio API"
	by Boris Smus at http://www.html5rocks.com/en/tutorials/webaudio/intro/ .
	Code samples licensed under the Apache 2.0 License.
*/

/*jslint browser */

/*global AudioContext, window, alert, XMLHttpRequest */

/*property
    AudioContext, buffer, connect, createBuffer, createBufferSource,
    decodeAudioData, destination, onload, open, response, responseType, send,
    start, webkitAudioContext
*/

var mistakeBuffer = null;
var tingBuffer = null;
var mistakeReady = false;
var tingReady = false;

window.AudioContext = window.AudioContext || window.webkitAudioContext;
var context = new AudioContext();

function onError(e) {
    "use strict";
    alert("sounds:onError: " + e);
}

function loadBuffer(url, callback) {
    "use strict";
	var request = new XMLHttpRequest();

	request.open("GET", url, true);
	request.responseType = "arraybuffer";

	request.onload = function () {
    	context.decodeAudioData(request.response, function (buffer) {
			callback(buffer);
		}, onError);
	};
	request.send();
}

function playSound(buffer) {
    "use strict";
	var source = context.createBufferSource();

	source.buffer = buffer;
	source.connect(context.destination);
	source.start(0);
}

function unlockSound() {
    "use strict";
	var buffer = context.createBuffer(1, 1, 22050);

	playSound(buffer);
}

function beep() {
	"use strict";
	playSound(mistakeBuffer);
}

function ack() {
	"use strict";
	playSound(tingBuffer);
}

var initSound = function () {
	"use strict";
	var mistakeURL = "Resources/Sounds/mistake.mp3";
	var tingURL = "Resources/Sounds/ting.mp3";

	loadBuffer(mistakeURL, function (buffer) {
    	mistakeBuffer = buffer;
    	mistakeReady = true;
	});

	loadBuffer(tingURL, function (buffer) {
    	tingBuffer = buffer;
    	tingReady = true;
	});
};
