/*
	Signal Object
	Copyright © 2012-2019 Dean Beedell and Harry Whitfield

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2 of the License, or (at your
	option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA	 02110-1301	 USA

	Signal Object
	21 September, 2016, updated 11 February 2019

	Graphics by Dean Beedell
	dean.beedell@lightquick.co.uk

	Browser version code by Harry Whitfield
	g6auc@arrl.net
*/

/*jslint browser */

/*global newCanvas, newCanvasImage, newImage, drawImage, requestAnimationFrame */

/*property
    abs, animationDuration, done, greenLamp, index, indexOf, intervalID, lamp,
    now, opacity, redLamp, rotateAnimation, rotation, semaphore,
    semaphoreImage, setAngle, setAspect, setTitle, signalType, src, state,
    style, title
*/

var ack;
var beep;

//////////////////////////////////////////////////////////////////////////////////////////

function Signal(signalType, hOffset, vOffset, zOrder) {
    "use strict";
	/*
		signalType must be one of:
			"home"
			"distant"
			"homeAlt"
			"distantAlt"
	*/

	var	base = "Resources/Signals/";
	var homeImage = base + signalType + "Img.png";
	var redLamp = base + "red.png";
	var greenLamp = base + "green.png";
	var yellowLamp = base + "yellow.png";
	var animationDuration = 375;	// 375 mS
//	var animationInterval = 16.666;	// 16.666  mS
	var o = {};
	var atEndAnimation;


	if (signalType.indexOf("distant") === 0) {
		redLamp = yellowLamp;
	}

	if (signalType.indexOf("Alt") < 0) {
		o.semaphore = newCanvas(hOffset, vOffset, 230, 230, homeImage, zOrder, 1.0, 115, 115);
		o.lamp = newImage(hOffset + 105, vOffset + 80, 80, 80, redLamp, zOrder + 1, 0.0, 40, 40);
	} else {
		o.semaphore = newCanvas(hOffset, vOffset, 260, 260, homeImage, zOrder, 1.0, 130, 130);
		o.lamp = newImage(hOffset + 82, vOffset + 108, 80, 80, redLamp, zOrder + 1, 0.0, 40, 40);
	}

	o.semaphoreImage = newCanvasImage(o.semaphore, function callback(img) {
		drawImage(o.semaphore, img, 0, 0, 0);
	});

	o.redLamp = redLamp;
	o.greenLamp = greenLamp;
	o.signalType = signalType;
	o.animationDuration = animationDuration;
	o.semaphore.rotation = 0;
	o.state = 0;
	o.done = null;
	o.index = null;
	o.intervalID = null;

	function setAngle(angle) {
		drawImage(o.semaphore, o.semaphoreImage, 0, 0, angle);
		o.semaphore.rotation = angle;
		o.lamp.style.opacity = Math.abs(angle - 22.5) / 22.5;
	}

	function rotateAnimation(startAngle, endAngle, duration) {
		var range = endAngle - startAngle;
		var startTime = Date.now();

		function draw() {
			var now = Date.now();
			var fraction = (now - startTime) / duration;
			var angle = startAngle + fraction * range;

			if (fraction >= 1) {
				setAngle(endAngle);
				o.intervalID = null;
				atEndAnimation();
				return;
			}
			setAngle(angle);
			o.intervalID = requestAnimationFrame(draw);
		}
		o.intervalID = requestAnimationFrame(draw);
	}

	atEndAnimation = function () {
		switch (o.state) {
		case 0:
			o.lamp.src = greenLamp;
			rotateAnimation(o.semaphore.rotation, 45, animationDuration);
			o.state = 1;
			break;
		case 1:
			rotateAnimation(o.semaphore.rotation, 37, animationDuration);
			o.state = 2;
			break;
		case 2:
			rotateAnimation(o.semaphore.rotation, 45, animationDuration);
			o.state = 3;
			break;
		case 3:
			if (o.done) {
				o.done(o.index);
			}
			break;

		case 4:
			o.lamp.src = redLamp;
			rotateAnimation(o.semaphore.rotation, 0, animationDuration);
			o.state = 5;
			break;
		case 5:
			rotateAnimation(o.semaphore.rotation, 8, animationDuration);
			o.state = 6;
			break;
		case 6:
			rotateAnimation(o.semaphore.rotation, 0, animationDuration);
			o.state = 7;
			break;
		case 7:
			if (o.done) {
				o.done(o.index);
			}
			break;
		}
	};

	o.setAspect = function (aspect, done, index) {
		switch (aspect) {
		case "caution":
		case "stop":
			if (o.semaphore.rotation !== 0) {
				o.done = done;
				o.index = index;
				o.state = 4;
				o.rotateAnimation(o.semaphore.rotation, 23, o.animationDuration);
				ack();
			} else {
				beep();
			}
			break;
		case "clear":
			if (o.semaphore.rotation !== 45) {
				o.done = done;
				o.index = index;
				o.state = 0;
				o.rotateAnimation(o.semaphore.rotation, 22, o.animationDuration);
				ack();
			} else {
				beep();
			}
			break;
		}
	};

	o.setTitle = function (title) {
		o.semaphore.title = title;
	};

	o.setAngle = setAngle;
	o.rotateAnimation = rotateAnimation;

	return o;
}
