/*
	Signal Widget
	Copyright © 2012-2016 Dean Beedell and Harry Whitfield

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2 of the License, or (at your
	option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA	 02110-1301	 USA

	Signal Widget
	7 September, 2016

	Graphics by Dean Beedell
	dean.beedell@lightquick.co.uk

	Browser version code by Harry Whitfield
	g6auc@arrl.net
*/

/*jslint browser, for, multivar, this */

/*global newDiv, newImage, Signal, setStyle, Traffic_Light */

/*property
    AudioContext, altKey, buffer, connect, createBuffer, createBufferSource,
    decodeAudioData, destination, index, indexOf, innerHTML, ondblclick,
    onload, opacity, open, response, responseType, send, setAngle, setAspect,
    setIndex, setOnClick, setOpacity, setTooltip, shiftKey, start, style,
    title, webkitAudioContext
*/

///////////////////////////////////// Web Audio API //////////////////////////////////////

/*
	Web Audio API
	Based on code samples from the page "Getting Started with Web Audio API"
	by Boris Smus at http://www.html5rocks.com/en/tutorials/webaudio/intro/ .
	Code samples licensed under the Apache 2.0 License.
*/

/*global AudioContext, window, alert, XMLHttpRequest */

/* property
    AudioContext, buffer, connect, createBuffer, createBufferSource,
    decodeAudioData, destination, onload, open, response, responseType, send,
    start, webkitAudioContext
*/

var mistakeBuffer = null;
var tingBuffer = null;
var mistakeReady = false;
var tingReady = false;

window.AudioContext = window.AudioContext || window.webkitAudioContext;
var context = new AudioContext();

function onError(e) {
    "use strict";
    alert("sounds:onError: " + e);
}

function loadBuffer(url, callback) {
    "use strict";
	var request = new XMLHttpRequest();

	request.open("GET", url, true);
	request.responseType = "arraybuffer";

	request.onload = function () {
    	context.decodeAudioData(request.response, function (buffer) {
			callback(buffer);
		}, onError);
	};
	request.send();
}

function playSound(buffer) {
    "use strict";
	var source = context.createBufferSource();

	source.buffer = buffer;
	source.connect(context.destination);
	source.start(0);
}

function unlockSound() {
    "use strict";
	var buffer = context.createBuffer(1, 1, 22050);

	playSound(buffer);
}

function beep() {
	"use strict";
	playSound(mistakeBuffer);
}

function ack() {
	"use strict";
	playSound(tingBuffer);
}

var initSound = function () {
	"use strict";
	var mistakeURL = "Resources/Sounds/mistake.mp3";
	var tingURL = "Resources/Sounds/ting.mp3";

	loadBuffer(mistakeURL, function (buffer) {
    	mistakeBuffer = buffer;
    	mistakeReady = true;
	});

	loadBuffer(tingURL, function (buffer) {
    	tingBuffer = buffer;
    	tingReady = true;
	});
};

////////////////////////////////////// Signal Code ///////////////////////////////////////

var pole = newImage(0, 0, 320, 640, "Resources/Signals/pole.png", 1, 0.0);

var signal = [];
var signalType = ["home", "distant", "homeAlt", "distantAlt"];

signal[0] = new Signal("home", 89, 12, 10);
signal[1] = new Signal("distant", 89, 140, 10);
signal[2] = new Signal("homeAlt", 74, 253, 10);
signal[3] = new Signal("distantAlt", 74, 381, 10);

var legend = newDiv(150, 660, 0);
var style = "font-family:'Lucida Grande',Helvetica;font-size:24px;color:black;background-color:transparent;border:none;text-align:center";
setStyle(legend, style);

var dropZone = newImage(66, 596, 96, 128, "Resources/Images/image2.png", 0, 0.0);
dropZone.title = "Alt+double-click to set all signals to clear.\nShift+double-click to set all signals to danger.";

//////////////////////////////////// Signal Test Code ////////////////////////////////////

var trafficLight = [];

var stopDone = function (i) {
    "use strict";
	trafficLight[i].setOpacity("green", 0.25);
};

var cautionDone = function (i) {
    "use strict";
	trafficLight[i].setOpacity("green", 0.25);
};

var clearDone = function (i) {
    "use strict";
	if (signalType[i].indexOf("distant") === 0) {
		trafficLight[i].setOpacity("amber", 0.25);
	} else {
		trafficLight[i].setOpacity("red", 0.25);
	}
};

dropZone.ondblclick = function (event) {
    "use strict";
    var i;

	for (i = 0; i < 4; i += 1) {
		if (event.altKey) {		// set all to clear
			trafficLight[i].setOpacity("green", 1.0);
			signal[i].setAspect("clear", clearDone, i);
		} else if (event.shiftKey) {	// set all to danger
			if (signalType[i].indexOf("home") === 0) {
				trafficLight[i].setOpacity("red", 1.0);
				signal[i].setAspect("stop", stopDone, i);
			} else {
				trafficLight[i].setOpacity("amber", 1.0);
				signal[i].setAspect("caution", cautionDone, i);
			}
		}
	}
};

var redClick = function () {
    "use strict";
	var i = this.index;

	if (signalType[i].indexOf("home") === 0) {
		trafficLight[i].setOpacity("red", 1.0);
		signal[i].setAspect("stop", stopDone, i);
	}
};

var amberClick = function () {
    "use strict";
	var i = this.index;

	if (signalType[i].indexOf("distant") === 0) {
		trafficLight[i].setOpacity("amber", 1.0);
		signal[i].setAspect("caution", cautionDone, i);
	}
};

var greenClick = function () {
    "use strict";
	var i = this.index;

	trafficLight[i].setOpacity("green", 1.0);
	signal[i].setAspect("clear", clearDone, i);
};

function makeControlPanel(hOffset, vOffset) {
    "use strict";
	var t, y, i;

	for (i = 0; i < 4; i += 1) {
		t = new Traffic_Light(hOffset + 22 * i, vOffset, 0);
		trafficLight[i] = t;
		y = signalType[i];

		if (y.indexOf("home") === 0) {
			t.setTooltip("red", "set signal to stop");
		} else {
			t.setTooltip("amber", "set signal to caution");
		}
		t.setTooltip("green", "set signal to clear");

		t.setIndex("red", i);
		t.setIndex("amber", i);
		t.setIndex("green", i);

		if (y.indexOf("distant") === 0) {
			t.setAspect("amber_green");
		} else {
			t.setAspect("red_green");
		}

		t.setOpacity("green", 0.25);

		t.setOnClick("red", redClick);
		t.setOnClick("amber", amberClick);
		t.setOnClick("green", greenClick);
	}
}

function start() {
    "use strict";
    var i;

    pole.style.opacity = 1.0;

    for (i = 0; i < 4; i += 1) {
    	signal[i].setAngle(0);
	}

	dropZone.style.opacity = 1.0;

	makeControlPanel(0, 640);
	legend.innerHTML = "Control Panel";
	initSound();
}

start();

//setTimeout(start, 4000);
