/*
	Web Audio API
	Based on code samples from the page "Getting Started with Web Audio API"
	by Boris Smus at http://www.html5rocks.com/en/tutorials/webaudio/intro/ .
	Code samples licensed under the Apache 2.0 License.
*/

/*jslint browser */

/*global AudioContext, window, alert, XMLHttpRequest */

/*property
    AudioContext, buffer, connect, createBuffer, createBufferSource,
    decodeAudioData, destination, onload, open, response, responseType, send,
    start, webkitAudioContext
*/

var buzzerBuffer = null;
var keyPressBuffer = null;
var cReturnBuffer = null;

var buzzerReady = false;
var keyPressReady = false;
var cReturnReady = false;

window.AudioContext = window.AudioContext || window.webkitAudioContext;
var context = new AudioContext();

function onError(e) {
    "use strict";
    alert("sounds:onError: " + e);
}

function loadBuffer(url, callback) {
    "use strict";
	var request = new XMLHttpRequest();

	request.open("GET", url, true);
	request.responseType = "arraybuffer";

	request.onload = function () {
    	context.decodeAudioData(request.response, function (buffer) {
			callback(buffer);
		}, onError);
	};
	request.send();
}

function initSound() {
	"use strict";
	var buzzerURL = "Resources/Sounds/buzzer.mp3";
	var keyPressURL = "Resources/Sounds/keypress.mp3";
	var cReturnURL = "Resources/Sounds/creturn.mp3";

	loadBuffer(buzzerURL, function (buffer) {
    	buzzerBuffer = buffer;
    	buzzerReady = true;
	});

	loadBuffer(keyPressURL, function (buffer) {
    	keyPressBuffer = buffer;
    	keyPressReady = true;
	});

	loadBuffer(cReturnURL, function (buffer) {
    	cReturnBuffer = buffer;
    	cReturnReady = true;
	});
}

function playSound(buffer) {
    "use strict";
	var source = context.createBufferSource();

	source.buffer = buffer;
	source.connect(context.destination);
	source.start(0);
}

function unlockSound() {
    "use strict";
	var buffer = context.createBuffer(1, 1, 22050);

	playSound(buffer);
}

export {initSound, playSound, unlockSound};
export {buzzerBuffer, keyPressBuffer, cReturnBuffer};
export {buzzerReady, keyPressReady, cReturnReady};
