/*
    Web Widget
    Copyright 2014,2015 Harry Whitfield

    This program is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any later
    version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
    PARTICULAR PURPOSE.  See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with
    this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
    St, Fifth Floor, Boston, MA  02110-1301  USA

    Web Widget - browser version 1.0.1
    7 May, 2015
    Copyright 2014,2015 Harry Whitfield
    mailto:g6auc@arrl.net
 */

/*properties
    PI, add, appendChild, body, clearRect, cols, createElement, createTextNode,
    ctx, div, drawImage, fillText, font, getContext, hRegP, height, indexOf,
    left, length, match, opacity, prototype, replace, restore, rotate, round,
    rows, save, scale, setAttribute, setStyle, size, split, src, style, text,
    toUpperCase, top, translate, type, vRegP, value, width, zOrder
*/

///////////////////////////// Start of the setStyle function /////////////////////////////

Object.prototype.setStyle = function (styleString) {
    var item, key, value, items = styleString.split(';'), last = items[items.length - 1], i;
    
	function trim(s) {
		return s.replace(/^\s+|\s+$/g, "");
	}

	function toCamelCase(s) {
		var k, t = "", ok = /^\-?[a-z]+(\-[a-z]+)*$/;
		
		if (s.match(ok) === null) {
			alert("Badly formed css attribute: " + s);
			return "";
		}
	
		for (k = 0; k < s.length; k += 1) {
			if (s[k] === "-") {
				k += 1;
				t += s[k].toUpperCase();
			} else {
				t += s[k];
			}
		}
		return t;
	}
	
    if ((last === "") || (last.indexOf(":") === -1)) { items.length -= 1; } 	// remove empty entry
    	
    for (i = 0; i < items.length; i += 1) {
        item  = items[i].split(":");
        key   = trim(item[0]);
        value = trim(item[1]);
        key   = toCamelCase(key);
        if (key !== "") {
			this[key] = value;
		}
    }
};

////////////////////////////// End of the setStyle function //////////////////////////////

//////////////////////////// Start of the webWidget functions ////////////////////////////

var scale = 1.0, vtop = 20, left = 20, fScale = 6.0;	// was 6.67

function newElement(tagName, hOffset, vOffset, zOrder) {
	var div = document.createElement("div"), ele;

	div.setAttribute("style", "position: absolute; left: " + String(hOffset + left) +
		"px; top: " + String(vOffset + vtop) + "px; z-index: " + String(zOrder) + ";");

	document.body.appendChild(div);
		
	ele = document.createElement(tagName);
	ele.left = hOffset;
	ele.top  = vOffset;
	ele.div = div;
	ele.zOrder = zOrder;
	div.appendChild(ele);

	return ele;
}

function moveObj(obj, hOffset, vOffset) {
	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);

	obj.div.setAttribute("style", "position: absolute; left: " + String(hOffset + left) +
		"px; top: " + String(vOffset + vtop) + "px; z-index: " + String(obj.zOrder) + ";");
}

function move(obj) {
	obj.div.setAttribute("style", "position: absolute; left: " + String(obj.left + left) +
		"px; top: " + String(obj.top + vtop) + "px; z-index: " + String(obj.zOrder) + ";");
}

function newImage(hOffset, vOffset, width, height, src, zOrder, opacity) {
	var img;

	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);
	
	img = newElement("img", hOffset, vOffset, zOrder);
	
	img.width  = Math.round(scale * width);
	img.height = Math.round(scale * height);
	img.src = src;
	if (opacity === undefined) { opacity = 1.0; }	// opacity is an optional parameter
	img.style.opacity = opacity;
	return img;
}

function newText(hOffset, vOffset, width, height, value, zOrder, style) {
	var text;

	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);
	
	text = newElement("input", hOffset, vOffset, zOrder);
	text.type = "text";

	text.width = Math.round(scale * width);
	text.size  = Math.round(scale * width / fScale);
	text.height = Math.round(scale * height);
	text.value = value;
	if (style !== undefined) {	// style is an optional parameter
		text.style.setStyle(style);
	}
	return text;
}

function newPara(hOffset, vOffset, width, height, value, zOrder, style) {
	var para, text;

	vOffset = vOffset - 9 * height / 16;
	
	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);
	
	para = newElement("p", hOffset, vOffset, zOrder);
	text = document.createTextNode(value);
	if (style !== undefined) {	// style is an optional parameter
		para.style.setStyle(style);
	}
	para.appendChild(text);
	return para;				// para.innerHTML = value to change the text
}

function newTextArea(hOffset, vOffset, cols, rows, value, zOrder, style) {
	var textarea;

	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);
	
	textarea = newElement("textarea", hOffset, vOffset, zOrder);
	
	textarea.cols  = cols;
	textarea.rows  = rows;
	textarea.value = value;
	if (style !== undefined) {	// style is an optional parameter
		textarea.style.setStyle(style);
	}
	return textarea;
}

function newInput(hOffset, vOffset, width, height, value, zOrder, style) {
	var input;

	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);
	
	input = newElement("input", hOffset, vOffset, zOrder);
	input.type = "text";
	
	input.width = Math.round(scale * width);
	input.size  = Math.round(scale * width / fScale);
	input.height = Math.round(scale * height);
	input.value = value;
	if (style !== undefined) {	// style is an optional parameter
		input.style.setStyle(style);
	}
	return input;
}

function newCanvas(hOffset, vOffset, width, height, src, zOrder, opacity, hRegP, vRegP) {
	var canvas;
	
	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);
	
	canvas = newElement("canvas", hOffset, vOffset, zOrder);

	hRegP = hRegP || 0;		// hRegP and vRegP are optional parameters
	vRegP = vRegP || 0;

	canvas.src = src;
	if (opacity === undefined) { opacity = 1.0; }	// opacity is an optional parameter
	canvas.style.opacity = opacity;
	
	canvas.width = Math.round(scale * width);
	canvas.height = Math.round(scale * height);
	canvas.ctx = canvas.getContext("2d");
	canvas.hRegP = Math.round(scale * hRegP);
	canvas.vRegP = Math.round(scale * vRegP);
	return canvas;
}

function newCanvasImage(canvas) {
	var img = new Image();
	
	img.width  = canvas.width;
	img.height = canvas.height;
	img.src    = canvas.src;
	return img;
}

function drawImage(canvas, img, hOff, vOff, ang) {
	var ctx = canvas.ctx, width = canvas.width, height = canvas.height,
		hRegP = canvas.hRegP, vRegP = canvas.vRegP;

	ctx.save();
	ctx.clearRect(0, 0, width, height);
	ctx.translate(hRegP, vRegP);
	ctx.rotate(Math.PI * ang / 180);
	ctx.translate(-hRegP, -vRegP);
	ctx.scale(scale, scale);
	ctx.drawImage(img, hOff, vOff);
	ctx.restore();
}

function drawText(canvas, text, hOff, vOff, ang, font) {
	var ctx = canvas.ctx, width = canvas.width, height = canvas.height,
		hRegP = canvas.hRegP, vRegP = canvas.vRegP;
	
	ctx.save();
	ctx.clearRect(0, 0, width, height);
	ctx.translate(hRegP, vRegP);
	ctx.rotate(Math.PI * ang / 180);
	ctx.translate(-hRegP, -vRegP);
	ctx.scale(scale, scale);
	ctx.font = font;
	ctx.fillText(text, hOff, vOff); 
	ctx.restore();
}

function newSelector(hOffset, vOffset, width, height, src, zOrder, opacity) {
	var selector;

	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);
	
	selector = newElement("select", hOffset, vOffset, zOrder);
	
	selector.width  = Math.round(scale * width);
	selector.height = Math.round(scale * height);
	selector.src = src;
	if (opacity === undefined) { opacity = 1.0; }	// opacity is an optional parameter
	selector.style.opacity = opacity;
	
//	selector.style.fontWeight = "bold";
//	selector.style.fontSize   = "14px";
	
	return selector;
}

function addToMenu(selector, strings) {
	var i, option;

	for (i = 0; i < strings.length; i += 1) {
		option = document.createElement("option");
		option.text = strings[i];
		selector.add(option);
	}
}

var moveImg = moveObj;	// for backwards compatibility

///////////////////////////// End of the webWidget functions /////////////////////////////
