/*
	Web Storage for Preferences
	Copyright © 2019 Harry Whitfield

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to the Free
	Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
	MA	02110-1301	USA

	Web Storage for Preferences - browser version 1.0
	26 April, 2019
	Copyright © 2019 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*jslint browser */

/*property
	getItem, removeItem, setItem
*/

var widgetName = "Protractor";

function setPreference(key, value) {
	if (Storage !== undefined) {
		localStorage.setItem(widgetName + ":" + key, value);
	}
}

function getPreference(key) {
	if (Storage !== undefined) {
		return localStorage.getItem(widgetName + ":" + key);
	}
	return null;
}

function removePreference(key) {
	if (Storage !== undefined) {
		localStorage.removeItem(widgetName + ":" + key);
	}
}

///////////////////////////////////// Preference Code ////////////////////////////////////

// default prefs follow

var scalePref = "100";
var bgAlphaPref = "100";
var compassAlphaPref = "100";
var compassStylePref = "Default Compass";
var rotationPref = "0";
var markerAnglePref = "0";
var markerDirectionPref = "0";	// clockwise
var compassDeltaPref = "0";

function getPreferences() {
	var scale;
	var bgAlpha;
	var compassAlpha;
	var compassStyle;
	var rotation;
	var markerAngle;
	var markerDirection;
	var compassDelta;

	scale = getPreference("scalePref");
	if (scale !== null) {
		scalePref = scale;
	}
	bgAlpha = getPreference("bgAlphaPref");
	if (bgAlpha !== null) {
		bgAlphaPref = bgAlpha;
	}
	compassAlpha = getPreference("compassAlphaPref");
	if (compassAlpha !== null) {
		compassAlphaPref = compassAlpha;
	}
	compassStyle = getPreference("compassStylePref");
	if (compassStyle !== null) {
		compassStylePref = compassStyle;
	}
	rotation = getPreference("rotationPref");
	if (rotation !== null) {
		rotationPref = rotation;
	}
	markerAngle = getPreference("markerAnglePref");
	if (markerAngle !== null) {
		markerAnglePref = markerAngle;
	}
	markerDirection = getPreference("markerDirectionPref");
	if (markerDirection !== null) {
		markerDirectionPref = markerDirection;
	}
	compassDelta = getPreference("compassDeltaPref");
	if (compassDelta !== null) {
		compassDeltaPref = compassDelta;
	}
}

getPreferences();				// pick up preferences stored in localStorage

