/*
	Protractor - A Screen Protractor
	Copyright © 2008-2019 Harry Whitfield

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2 of the License, or (at your
	option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA	 02110-1301	 USA

	Protractor - browser version 1.0
	8 February 2019
	Copyright © 2008-2019 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*jslint browser, devel */

/*global cookiesPermitted, getPreference, setPreference */

/*property
    cookieEnabled
*/

var permitCookies;	// declared and initialised in cookies.js

var gScalePref;
var gBgAlphaPref;
var gCompassAlphaPref;
var gCompassStylePref;
var gRotationPref;
var gMarkerAnglePref;
var gMarkerDirectionPref;
var gCompassDeltaPref;

var scalePref;
var bgAlphaPref;
var compassAlphaPref;
var compassStylePref;
var rotationPref;
var markerAnglePref;
var markerDirectionPref;
var compassDeltaPref;
var gWidgetName;


function getPreferences2() {
	var scale;
	var bgAlpha;
	var compassAlpha;
	var compassStyle;
	var rotation;
	var markerAngle;
	var markerDirection;
	var compassDelta;

    if (navigator.cookieEnabled) {
    	scale = getPreference("scalePref");
        if (scale !== "") {
        	scalePref = scale;
         	permitCookies = true;
		}
    	bgAlpha = getPreference("bgAlphaPref");
        if (bgAlpha !== "") {
        	bgAlphaPref = bgAlpha;
         	permitCookies = true;
		}
    	compassAlpha = getPreference("compassAlphaPref");
        if (compassAlpha !== "") {
        	compassAlphaPref = compassAlpha;
         	permitCookies = true;
		}
    	compassStyle = getPreference("compassStylePref");
        if (compassStyle !== "") {
        	compassStylePref = compassStyle;
         	permitCookies = true;
		}
    	rotation = getPreference("rotationPref");
        if (rotation !== "") {
        	rotationPref = rotation;
         	permitCookies = true;
		}
    	markerAngle = getPreference("markerAnglePref");
        if (markerAngle !== "") {
        	markerAnglePref = markerAngle;
         	permitCookies = true;
		}
    	markerDirection = getPreference("markerDirectionPref");
        if (markerDirection !== "") {
        	markerDirectionPref = markerDirection;
         	permitCookies = true;
		}
    	compassDelta = getPreference("compassDeltaPref");
        if (compassDelta !== "") {
        	compassDeltaPref = compassDelta;
         	permitCookies = true;
		}
	}
}

function cookieAlert() {
    "use strict";
	if (cookiesPermitted()) {
    	setPreference("scalePref", gScalePref);
    	setPreference("bgAlphaPref", gBgAlphaPref);
    	setPreference("compassAlphaPref", gCompassAlphaPref);
    	setPreference("compassStylePref", gCompassStylePref);
    	setPreference("rotationPref", gRotationPref);
    	setPreference("markerAnglePref", gMarkerAnglePref);
    	setPreference("markerDirectionPref", gMarkerDirectionPref);
    	setPreference("compassDeltaPref", gCompassDeltaPref);
	}
}

getPreferences2();				// pick up preferences stored as cookies
gWidgetName = "Protractor Widget\n\n";
setTimeout(cookieAlert, 2000);	// produce cookie alert if required.
