/*
    NetCalc - An RF Impedance Calculator
    Copyright 2000-2015 Harry Whitfield

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    NetCalc - version 2.2
    6 July, 2015
    Copyright 2000-2015 Harry Whitfield
    g6auc@arrl.net
*/

// ∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞
//
// NetCalc - An RF Impedance Calculator
//
// Copyright © 2000-2015 by Harry Whitfield, G6AUC. All Rights Reserved.
//
// Broadly based on NETCALC - an RF Impedance Calculator by Ian White, G3SEK.
//
// The concepts and command names follow NETCALC, but the coding and design
// of this program are entirely new.
//
// This program can also display impedances on a diagram similar to the
// well-known Smith Chart.
//
// The L-section code is based on a PERL program
// by Claude Frantz <claude@pc0312a.rz.unibw-muenchen.de>
//
// ∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞

/*jslint browser, multivar */

/*global showMod, btnVSWR, btndot, btnS, btnCS, btnHelp, btnXL, btnXLP, btnXX, btnXXP,
    btnXC, btnXCP, btnE, btnSeries, btnParallel, btnJ, btnmul, btndiv,
    btnT, btnC, btnQ, btnX, btnL, showVSWR, btnLS,
    menuRn, menuQn, menuMn, update, impCHART, writeEPSdata, eprint,
    scale, newImage, newSelector, addToMenu, newInput, alert
*/

/*property
    PI, altKey, backgroundColor, border, checked, drawMarker, height, onchange,
    onmousedown, onmouseup, opacity, round, selectedIndex, setDrawColor, split,
    style, title, value, width
*/

//////////////////////////////////////////////////////////////////////////////////////////

var main_window = {width: Math.round(644 * scale), height: Math.round(442 * scale)},
    halfWidth = Math.round(main_window.width / 2),
    halfHeight = Math.round(main_window.height / 2),

    radToDeg = 180 / Math.PI,
    degToRad = Math.PI / 180,
    rotToPc = 100 / 360;

//////////////////////////////////////////////////////////////////////////////////////////

var precision = 6;                      // for use in toFixed(precision)

var FMultiplier = 0;                    // to be set by menuAction
var RMultiplier = 0;                    // to be set by menuAction
var LMultiplier = -6;                   // to be set by menuAction
var XMultiplier = 0;                    // to be set by menuAction
var CMultiplier = -12;                  // to be set by menuAction

var degreeSign = "°";
var ohmSign = "Ω";

var Mreg = ["0,0", "0,0", "0,0", "0,0", "0,0", "0,0", "0,0", "0,0", "0,0", "0,0"];  // Memory Registers 1..9

///////////////////////////////////////// buttons ////////////////////////////////////////

var calculator, modX, modN, Circle, dot, S, CS, Help, XL, XLP, XX, XXP, XC, XCP, E,
        Series, Parallel, Home, J, mul, div, Prev, Z0, T, C, Next, Q, X, L, W, LS;

var base = "Resources/Images/";

(function () {
    "use strict";
//  mainWindow.width = Math.round(scale * 644);
//  mainWindow.height = Math.round(scale * 442);

//  newImage(hOffset, vOffset, width, height, src, zOrder, opacity, hRegP, vRegP)
//  newCanvas(hOffset, vOffset, width, height, src, zOrder, opacity, hRegP, vRegP)

    calculator = newImage(0, 0, 644, 442, base + "Main.png", 1);
    modX = newImage(91, 303, 35, 27, base + "modX.png", 2);
    modN = newImage(134, 303, 35, 27, base + "modN.png", 2);
    Circle = newImage(197, 303, 35, 27, base + "Circle.png", 2);
    dot = newImage(240, 303, 35, 27, base + "dot.png", 2);
    S = newImage(283, 303, 35, 27, base + "S.png", 2);
    CS = newImage(326, 303, 35, 27, base + "CS.png", 2);
    Help = newImage(390, 52, 30, 22, base + "help.png", 2);
    XL = newImage(390, 81, 23, 26, base + "XL.png", 2);
    XLP = newImage(416, 81, 23, 26, base + "XLP.png", 2);
    XX = newImage(390, 110, 23, 26, base + "XX.png", 2);
    XXP = newImage(416, 110, 23, 26, base + "XXP.png", 2);
    XC = newImage(390, 139, 23, 26, base + "XC.png", 2);
    XCP = newImage(416, 139, 23, 26, base + "XCP.png", 2);
    E = newImage(422, 240, 35, 27, base + "E.png", 2);
    Series = newImage(466, 240, 35, 27, base + "Series.png", 2);
    Parallel = newImage(510, 240, 35, 27, base + "Parallel.png", 2);
    Home = newImage(554, 240, 35, 27, base + "home2.png", 2);
    J = newImage(422, 271, 35, 27, base + "J.png", 2);
    mul = newImage(466, 271, 35, 27, base + "star.png", 2);
    div = newImage(510, 271, 35, 27, base + "div.png", 2);
    Prev = newImage(554, 271, 35, 27, base + "prev.png", 2);
    Z0 = newImage(422, 303, 35, 27, base + "Z0.png", 2);
    T = newImage(466, 303, 35, 27, base + "T.png", 2);
    C = newImage(510, 303, 35, 27, base + "C.png", 2);
    Next = newImage(554, 303, 35, 27, base + "next.png", 2);
    Q = newImage(378, 335, 35, 27, base + "Q.png", 2);
    X = newImage(422, 335, 35, 27, base + "X.png", 2);
    L = newImage(466, 335, 35, 27, base + "L.png", 2);
    W = newImage(510, 335, 35, 27, base + "W.png", 2);
    LS = newImage(554, 335, 35, 27, base + "LS.png", 2);

}());

// set tooltips

modX.title = "Puts the modulus and argument of Z into Y.";
modN.title = "Puts the modulus and argument of N into Y.";
Circle.title = "Plots the VSWR circle on the impedance chart.";
dot.title = "Plots the current point (N = Z/Z0) on the impedance chart.";
S.title = "Steps through the chart modes. Mode = RX.";
CS.title = "Removes VSWR circles and (N) points from the impedance chart.";
Help.title = "Displays information about this program.";
XL.title = "Pushes impedance of resistor R in series with inductor L onto the stack.";
XLP.title = "Pushes impedance of resistor R in parallel with inductor L onto the stack.";
XX.title = "Pushes impedance of resistor R in series with reactance X onto the stack.";
XXP.title = "Pushes impedance of resistor R in parallel with reactance X  onto the stack.";
XC.title = "Pushes impedance of resistor R in series with capacitor C onto the stack.";
XCP.title = "Pushes impedance of resistor R in parallel with capacitor C onto the stack.";
E.title = "Exchanges the Z and A stack registers.";
Series.title = "Puts the impedance of Z in series with A into Z and pops A.";
Parallel.title = "Puts the impedance of Z in parallel with A into Z and pops A.";
Home.title = "Closes NetCalc.";
J.title = "Puts the conjugate of Z into Z.";
mul.title = "Multiplies Z by scalar Factor.";
div.title = "Divides Z by scalar Factor.";
Prev.title = "Cycles through the drawing colors.";
Z0.title = "Copies the value of Z into the Z0 register.";
T.title = "Adds the impedance of a transmission line of length Tlength to the impedance Z. (Set Factor and use alt or option key for lossy lines.)";
C.title = "Pops one element off the stack.\nAlt-click to clear the stack.";
Next.title = "Display the EPS data of the current Chart.";
Q.title = "Displays Q(Z) in Y.";
X.title = "Displays Inductor or Capacitor values corresponding to the reactances of Z and P.";
L.title = "Computes the length of a transmission line of characteristic impedance Z0 having the same reactance at frequency F as the impedance Z. Displays the result in Y.";
W.title = "Displays the Voltage Standing Wave Ratio of Z in Y.";
LS.title = "Displays L-sections which match Z to real part of Z0. (Use alt or option key to display reactances in ohms.)";

////////////////////////////////////////// menus /////////////////////////////////////////

var Farray = ["Hz", "kHz", "MHz", "GHz", "THz"];
var Rarray = ["Ω", "kΩ", "MΩ", "GΩ"];
var Larray = ["pH", "nH", "µH", "mH", "H", "kH"];
var Xarray = ["Ω", "kΩ", "MΩ", "GΩ"];
var Carray = ["pF", "nF", "µF", "mF", "F", "kF"];
var RnArray = ["Rn", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];
var QnArray = ["?n", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];
var MnArray = ["Mn", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];

var FMenu = newSelector(164, 166, 56, 20, "", 2);
var RMenu = newSelector(520, 52, 56, 20, "", 2);
var LMenu = newSelector(520, 81, 56, 20, "", 2);
var XMenu = newSelector(520, 110, 56, 20, "", 2);
var CMenu = newSelector(520, 138, 56, 20, "", 2);
var RnMenu = newSelector(364, 241, 35, 22, "", 2);
var QnMenu = newSelector(364, 272, 35, 22, "", 2);
var MnMenu = newSelector(364, 304, 35, 22, "", 2);

addToMenu(FMenu, Farray);
addToMenu(RMenu, Rarray);
addToMenu(LMenu, Larray);
addToMenu(XMenu, Xarray);
addToMenu(CMenu, Carray);
addToMenu(RnMenu, RnArray);
addToMenu(QnMenu, QnArray);
addToMenu(MnMenu, MnArray);

LMenu.selectedIndex = 2;

// set tooltips

FMenu.title = "Set frequency multiplier here.";
RMenu.title = "Set resistance multiplier here.";
LMenu.title = "Set inductance multiplier here.";
XMenu.title = "Set reactance multiplier here.";
CMenu.title = "Set capacitance multiplier here.";
RnMenu.title = "Pushes the  value of memory n (0..9) onto the stack (at Z).  Does not change memory n.";
QnMenu.title = "Displays the value of memory n (0..9) in Y. Does not change the stack or memory n.";
MnMenu.title = "Copies the Z register to memory register n (0..9). Does not change Z.";

////////////////////////////////////////// inputs ////////////////////////////////////////

var freq = newInput(94, 173, 48, 20, 1, 2);
freq.title = "Insert frequency value here.";
freq.style.backgroundColor = "transparent";
freq.style.border = "none";

var velfac = newInput(292, 173, 48, 20, 1, 2);
velfac.title = "Insert velocity factor of the transmission line here.";
velfac.style.backgroundColor = "transparent";
velfac.style.border = "none";

var resist = newInput(466, 59, 36, 20, 100, 2);
resist.title = "Insert resistance value here.";
resist.style.backgroundColor = "transparent";
resist.style.border = "none";

var induct = newInput(466, 88, 36, 20, 0, 2);
induct.title = "Insert inductance value here.";
induct.style.backgroundColor = "transparent";
induct.style.border = "none";

var react = newInput(466, 117, 36, 20, 0, 2);
react.title = "Insert reactance value here.";
react.style.backgroundColor = "transparent";
react.style.border = "none";

var capacit = newInput(466, 145, 36, 20, 0, 2);
capacit.title = "Insert capacitance value here.";
capacit.style.backgroundColor = "transparent";
capacit.style.border = "none";

var Factor = newInput(466, 173, 72, 20, 1, 2);
Factor.title = "Insert factor for use with * and / buttons. Insert attenuation factor in nepers per metre for use with TL button. Nepers = Decibels/8.686";
Factor.style.backgroundColor = "transparent";
Factor.style.border = "none";

var Tlength = newInput(466, 201, 72, 20, 0.1, 2);
Tlength.title = "Insert transmission line length for use with T/TL button. If < 1, it is regarded as a fraction of the wavelength. If >= 1, it is regarded as the length in mm.";
Tlength.style.backgroundColor = "transparent";
Tlength.style.border = "none";

///////////////////////////////////////// outputs ////////////////////////////////////////

var theYreg = newInput(94, 60, 234, 20, "0,0", 2);
theYreg.title = "Second stack register (in series form).";
theYreg.style.backgroundColor = "transparent";
theYreg.style.border = "none";

var theXreg = newInput(94, 88, 234, 20, "0,0", 2);
theXreg.title = "First stack register (in series form).";
theXreg.style.backgroundColor = "transparent";
theXreg.style.border = "none";

var Preg = newInput(94, 117, 234, 20, "0 || 0", 2);
Preg.title = "First stack register (in parallel form).";
Preg.style.backgroundColor = "transparent";
Preg.style.border = "none";

var Z0reg = newInput(94, 201, 234, 20, "50,0", 2);
Z0reg.title = "Characteristic Impedance of the transmission line.\n(Set with Z0 button.)";
Z0reg.style.backgroundColor = "transparent";
Z0reg.style.border = "none";

var Nreg = newInput(94, 246, 234, 20, "0.000000,0.000000", 2);
Nreg.title = "Normalized impedance Z/Z0.";
Nreg.style.backgroundColor = "transparent";
Nreg.style.border = "none";

var Rreg = newInput(94, 275, 234, 20, "1.000000 @ 180.000000°", 2);
Rreg.title = "Reflection coefficent in polar form.";
Rreg.style.backgroundColor = "transparent";
Rreg.style.border = "none";

var theZreg = newInput(94, 343, 234, 20, "VSWR=Infinity RL=0.000000dB", 2);
theZreg.title = "Normalized admittance Z0/Z = 1/N. Also used as a general results register.";
theZreg.style.backgroundColor = "transparent";
theZreg.style.border = "none";

///////////////////////////////////////// events /////////////////////////////////////////

function menuAction(menuName, i) {  // was , value) {
    "use strict";
    var mlist = "", item = [];

//  alert("Menu:" + menuName + " Index:" + i + " Value:" + value);

    switch (menuName) {
    case "FMenu":
        //list = "Hz,kHz,MHz,GHz,THz";
        mlist = "0,3,6,9,12";
        item = mlist.split(",");
        FMultiplier = Number(item[i]);
//      alert("FMultiplier=" + FMultiplier);
        break;
    case "RMenu":
        //list = "Ω,kΩ,MΩ,GΩ";
        mlist = "0,3,6,9";
        item = mlist.split(",");
        RMultiplier = Number(item[i]);
//      alert("RMultiplier=" + RMultiplier);
        break;
    case "LMenu":
        //list = "pH,nH,µH,mH,H,kH";
        mlist = "-12,-9,-6,-3,0,3,6,9";
        item = mlist.split(",");
        LMultiplier = Number(item[i]);
//      alert("LMultiplier=" + LMultiplier);
        break;
    case "XMenu":
        //list = "Ω,kΩ,MΩ,GΩ";
        mlist = "0,3,6,9";
        item = mlist.split(",");
        XMultiplier = Number(item[i]);
//      alert("XMultiplier=" + XMultiplier);
        break;
    case "CMenu":
        //list = "pF,nF,µF,mF,F,kF";
        mlist = "-12,-9,-6,-3,0,3,6,9";
        item = mlist.split(",");
        CMultiplier = Number(item[i]);
//      alert("CMultiplier=" + CMultiplier);
        break;
    case "RnMenu":
        menuRn(i);
        RnMenu.selectedIndex = 0;
        break;
    case "QnMenu":
        menuQn(i);
        QnMenu.selectedIndex = 0;
        break;
    case "MnMenu":
        menuMn(i);
        MnMenu.selectedIndex = 0;
        break;
    default:
        alert("beep");
    }
}

FMenu.onchange = function () {
    "use strict";
    menuAction("FMenu", FMenu.selectedIndex, FMenu.value);
};
RMenu.onchange = function () {
    "use strict";
    menuAction("RMenu", RMenu.selectedIndex, RMenu.value);
};
LMenu.onchange = function () {
    "use strict";
    menuAction("LMenu", LMenu.selectedIndex, LMenu.value);
};
XMenu.onchange = function () {
    "use strict";
    menuAction("XMenu", XMenu.selectedIndex, XMenu.value);
};
CMenu.onchange = function () {
    "use strict";
    menuAction("CMenu", CMenu.selectedIndex, CMenu.value);
};
RnMenu.onchange = function () {
    "use strict";
    menuAction("RnMenu", RnMenu.selectedIndex - 1, RnMenu.value);
};
QnMenu.onchange = function () {
    "use strict";
    menuAction("QnMenu", QnMenu.selectedIndex - 1, QnMenu.value);
};
MnMenu.onchange = function () {
    "use strict";
    menuAction("MnMenu", MnMenu.selectedIndex - 1, MnMenu.value);
};

function btnClose() {
    "use strict";
    alert("Please use the browser's close button.");
}

function btnRight() {
    "use strict";
    writeEPSdata();
}

var drawColor = 0;
var colors = ["#000000", "#0000FF", "#00FF00", "#FF0000", "#FFFF00", "#FF00FF", "#00FFFF"],
    colorName = ["BLACK", "BLUE", "GREEN", "RED", "YELLOW", "MAGENTA", "CYAN"];

function btnLeft() {
    "use strict";
    eprint("\nColor Button");
    drawColor = (drawColor + 1) % 7;
    impCHART.setDrawColor(colors[drawColor]);
    impCHART.drawMarker();
    eprint("\tNew drawing color is " + colorName[drawColor]);
}

function modXAction() {
    "use strict";
    eprint("\n|X| Button");
    showMod(theXreg.value);
}

function modNAction() {
    "use strict";
    eprint("\n|N| Button");
    showMod(Nreg.value);
}

function Z0Action() {
    "use strict";
    eprint("\nZ0 Button");
    Z0reg.value = theXreg.value;
    update();
}

function makeButton(obj, action) {
    "use strict";
    obj.onmousedown = function () {
        obj.style.opacity = "0.5";
    };
    obj.onmouseup = function () {
        obj.style.opacity = "1.0";
        action();
    };
}

/*
modX.onclick = function () { showMod(theXreg.value); };
modN.onclick = function () { showMod(Nreg.value); };

Circle.onclick = function () { btnVSWR(); };
dot.onclick = function () { btndot(); };
S.onclick = function () { btnS(); };
CS.onclick = function () { btnCS(); };

Help.onclick = function () { btnHelp(); };

XL.onclick = function () { btnXL(); };
XLP.onclick = function () { btnXLP(); };
XX.onclick = function () { btnXX(); };
XXP.onclick = function () { btnXXP(); };
XC.onclick = function () { btnXC(); };
XCP.onclick = function () { btnXCP(); };

E.onclick = function () { btnE(); };
Series.onclick = function () { btnSeries(); };
Parallel.onclick = function () { btnParallel(); };
Home.onclick = function () { btnClose(); };

J.onclick = function () { btnJ(); };
mul.onclick = function () { btnmul(); };
div.onclick = function () { btndiv(); };
Prev.onclick = function () { btnLeft(); };

Z0.onclick = function () { Z0reg.value = theXreg.value; update(); };
T.onclick = function (event) { btnT(event.altKey); };

C.onclick = function (event) { btnC(event.altKey); };
Next.onclick = function () { btnRight(); };

Q.onclick = function () { btnQ(); };
X.onclick = function () { btnX(); };
L.onclick = function () { btnL(); };
W.onclick = function () { showVSWR(); };
LS.onclick = function (event) { btnLS(event.altKey); };
*/

makeButton(modX, modXAction);
makeButton(modN, modNAction);

makeButton(Circle, btnVSWR);
makeButton(dot, btndot);
makeButton(S, btnS);
makeButton(CS, btnCS);

//makeButton(Help, btnHelp);

makeButton(XL, btnXL);
makeButton(XLP, btnXLP);
makeButton(XX, btnXX);
makeButton(XXP, btnXXP);
makeButton(XC, btnXC);
makeButton(XCP, btnXCP);

makeButton(E, btnE);
makeButton(Series, btnSeries);
makeButton(Parallel, btnParallel);
makeButton(Home, btnClose);

makeButton(J, btnJ);
makeButton(mul, btnmul);
makeButton(div, btndiv);
makeButton(Prev, btnLeft);

makeButton(Z0, Z0Action);

var altKey = null;

T.onmousedown = function () {
    "use strict";
    T.style.opacity = "0.5";
};
T.onmouseup = function (event) {
    "use strict";
    T.style.opacity = "1.0";
    btnT(event.altKey || altKey.checked);
};

C.onmousedown = function () {
    "use strict";
    C.style.opacity = "0.5";
};
C.onmouseup = function (event) {
    "use strict";
    C.style.opacity = "1.0";
    btnC(event.altKey || altKey.checked);
};

makeButton(Next, btnRight);

makeButton(Q, btnQ);
makeButton(X, btnX);
makeButton(L, btnL);
makeButton(W, showVSWR);

LS.onmousedown = function () {
    "use strict";
    LS.style.opacity = "0.5";
};
LS.onmouseup = function (event) {
    "use strict";
    LS.style.opacity = "1.0";
    btnLS(event.altKey || altKey.checked);
};

//////////////////////////////////////// L-section ////////////////////////////////////////

var Results = null; // for results of L-section calculation

//////////////////////////////////////////////////////////////////////////////////////////
