/*
	NetCalc - An RF Impedance Calculator
	Copyright 2000-2015 Harry Whitfield

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2 of the License, or (at your
	option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA	 02110-1301	 USA

	NetCalc - version 2.1.1
	6 April, 2015
	Copyright 2000-2015 Harry Whitfield
	g6auc@arrl.net
*/

/*global Help, btnHelp, newCanvas, newImage, impCHART, newTextArea, update, eprint,
    newInput
*/

/*property
    checked, onclick, onmousedown, onmouseup, opacity, setAttribute,
    setDrawColor, style, title, value
*/

var altKey;

////////////////////////////////////////// Help //////////////////////////////////////////

Help.onmousedown = function () {
    'use strict';
    Help.style.opacity = "0.5";
};
Help.onmouseup = function () {
    'use strict';
    Help.style.opacity = "1.0";
    btnHelp("Help.html");
};

//////////////////////////////////////// ImpChart ////////////////////////////////////////

var xBase = 14;		// narrow config	frame 700 x 1300
var yBase = 645;	// narrow config
/*
var xBase = 610;	// wide config		frame 1300 x 700
var yBase = 25;		// wide config
*/
var ImpChart = newCanvas(xBase + 53, yBase + 38, 564, 564, null, 10);

var ImpChartFrame = newImage(xBase, yBase, 670, 670, "Resources/Images/ImpChartFrame.png", 11);

var ctx = impCHART(ImpChart, "10", "Lucida Grande");	// Draw the chart

impCHART.setDrawColor("#000000");	// black

//ctx.font = "14px 'Lucida Grande'";
//ctx.fillStyle = "#000000";			// black
//ctx.fillText("Impedance Chart", 20, 25);	// Add a title

//////////////////////////////////////// Log Data ////////////////////////////////////////

var logData = newTextArea(48, 430, 40, 13, "", 21, "false");
logData.title = "For log data.";

function eprint(s) {
    'use strict';
    logData.value += s + "\n";
}

//////////////////////////////////////// EPS Data ////////////////////////////////////////

var epsData = newTextArea(330, 430, 40, 13, "", 20, "false");
epsData.title = "For EPS data.";

eprint("NetCalc - An RF Impedance Calculator");
eprint(new Date());
eprint("\nInitial Display Values:");
update();
eprint(" ");


//////////////////////////////////////// Alt-Key /////////////////////////////////////////

altKey = newInput(525, 400, 8, 16, "alt-key", 3);
altKey.setAttribute("type", "checkbox");

var altButton = newInput(466, 400, 8, 16, "alt-key", 3);
altButton.setAttribute("type", "button");

altButton.onclick = function () {
    'use strict';
    altKey.checked = !altKey.checked;
};
