/*
    NetCalc - An RF Impedance Calculator
    Copyright 2000-2014 Harry Whitfield

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    NetCalc - version 2.0
    22 December, 2014
    Copyright 2000-2014 Harry Whitfield
    g6auc@arrl.net
*/

/*jslint browser, multivar */

/*global impCHART, precision, rho, toComplex, theXreg, Z0reg, epsData,
    eprint, Nreg, Rreg, theZreg, alert, XMLHttpRequest
*/

/* properties
    color, modulus, open, plotCircle, plotPoint, r, reset, responseText, send,
    status, toFixed, value, x, y
*/

var drawColor;

var plotData = [];          // for EPS data
var pIndex = 0;


function drawCircle(rho) {
    "use strict";
    var radius;
    if (isFinite(rho.x) && isFinite(rho.y)) {
        radius = rho.modulus();

        plotData[pIndex] = {};
        plotData[pIndex].color = drawColor;
        plotData[pIndex].x = 0;
        plotData[pIndex].y = 0;
        plotData[pIndex].r = radius;
        pIndex += 1;

        impCHART.plotCircle(radius);
    } else {
        alert("Chart.js line 57");
    }
}

function placePoint(rho) {
    "use strict";
    if (isFinite(rho.x) && isFinite(rho.y)) {
        plotData[pIndex] = {};
        plotData[pIndex].color = drawColor;
        plotData[pIndex].x = rho.x;
        plotData[pIndex].y = rho.y;
        plotData[pIndex].r = 0.016;
        pIndex += 1;

        impCHART.plotPoint(rho.x, rho.y);
    } else {
        alert("Chart.js line 72");
    }
}

function btnVSWR() {
    "use strict";
    eprint("\nPlot VSWR Circle Button");
    drawCircle(rho(toComplex(theXreg.value), toComplex(Z0reg.value)));
    eprint("\tX:   " + theXreg.value);
    eprint("\tZ0:  " + Z0reg.value);
    eprint("\tN:   " + Nreg.value);
    eprint("\trho: " + Rreg.value);
    eprint("\tZ:   " + theZreg.value);
}

function btndot() {
    "use strict";
    eprint("\nPlot Current Point Button");
    placePoint(rho(toComplex(theXreg.value), toComplex(Z0reg.value)));
    eprint("\tX:   " + theXreg.value);
    eprint("\tZ0:  " + Z0reg.value);
    eprint("\tN:   " + Nreg.value);
    eprint("\trho: " + Rreg.value);
    eprint("\tZ:   " + theZreg.value);
}

function btnS() {
    "use strict";
    eprint("\nS Button");
}

function getColor(color) {
//  var colors = ["#000000", "#0000FF", "#00FF00", "#FF0000", "#FFFF00", "#FF00FF", "#00FFFF"];
//                  BLACK      BLUE       GREEN      RED        YELLOW     MAGENTA    CYAN
    "use strict";
    var colors = ["BLACK", "BLUE", "GREEN", "RED", "YELLOW", "MAGENTA", "CYAN"];

    color = color % 7;
    return colors[color];
}

function btnCS() {
    "use strict";
    eprint("\nClear Chart Button");
    impCHART.reset();
    drawColor = 0;
    plotData = [];
    pIndex = 0;
    eprint("\tNew drawing color is " + getColor(drawColor));
//  epsData.value = "For the EPS data of the Impedance Chart.";
}

function theEPSdata() {
    "use strict";
    var xx,
        yy,
        rr,
        ps = "lw5 3 mul setlinewidth\r\n",  // 3 for thicker lines
        i,
        cc,
        color = -1;

    i = 0;
    while (i < pIndex) {
        cc = plotData[i].color;
        xx = (plotData[i].x).toFixed(precision);
        yy = (plotData[i].y).toFixed(precision);
        rr = (plotData[i].r).toFixed(precision);

        if (cc !== color) {
            color = cc;
            ps += getColor(color) + "\r\n";
            ps += "newpath\r\n";
        }
        ps += xx + " " + yy + " " + rr + " 0 360 arc stroke\r\n";
        i += 1;
    }
    ps += "grestore\r\n";
    ps += "end\r\n";
    ps += "showpage\r\n";
    ps += "%%Trailer\r\n";
    ps += "%%EOF\r\n";
    return ps;
}

function getEPSfile() {
    "use strict";
    var request = new XMLHttpRequest();

    request.open("GET", "https://g6auc.me.uk/NetCalcWeb/Resources/ImpChart.ps", false);
    request.send();
    if (request.status === 200) {
        return request.responseText;
    }
    return "";
}

var impChartData = null;

function writeEPSdata() {
    "use strict";
    if (impChartData === null) {
        impChartData = getEPSfile();
    }

    epsData.value = impChartData + theEPSdata();
}
