/*
    Pixel Scale - A Screen Ruler
    Copyright © 2007, 2017, 2019 Harry Whitfield

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    Pixel Scale - browser version 1.2
    22 November 219
    Copyright © 2007, 2017, 2019 Harry Whitfield
    mailto:g6auc@arrl.net
*/

/*jslint browser, devel */

/*property
    areaFactor, base, getElementById, maxW, minW, onchange, ondblclick,
    pixelMode, ppiH, ppiV, preventDefault, rotation, scaleFactor, src, srcWidth,
    stopPropagation, title, value, width
*/

import {getPreference, setPreference} from "./preferences.js";
import {ruler, legend, label, thePPI} from "./pixelscale.js";
import {areaText} from "./planimeter.js";

//////////////////////////////////////// GUI setup ///////////////////////////////////////

let Menu = [];

Menu[0] = document.getElementById("selector0");   // defined in html file
Menu[0].title = "Choose a Scale";
Menu[0].value = getPreference("modePref");

//////////////////////////////////////////////////////////////////////////////////////////

function setMode(modePref) {
	switch (modePref) {
	case "40 pixels (10x4)":
		ruler.src = "Resources/Images/rulr40_10.png";
		legend.src = "Resources/Images/legd40.png";
		label.src = "Resources/Images/P40_10.png";
		//button.hOffset = ghOffset + 60;
		//buttonText.hOffset = ghOffset + 60;
		ruler.minW = 80;
		ruler.maxW = 1440;
		ruler.scaleFactor = 100;
		ruler.pixelMode = 100;
		ruler.areaFactor = 0;
		ruler.title = "Double-click to change to next pixel scale.";
		legend.title = ruler.title;
		label.title = ruler.title;
		areaText.title = areaText.base + "\n\nAreas and path lengths are given in pixels.";
		break;
	case "96 pixels (32x3)":
		ruler.src = "Resources/Images/rulr96_32.png";
		legend.src = "Resources/Images/legd96.png";
		label.src = "Resources/Images/P96_32.png";
		//button.hOffset = ghOffset + 48;
		//buttonText.hOffset = ghOffset + 48;
		ruler.minW = 96;
		ruler.maxW = 1440;
		ruler.scaleFactor = 100;
		ruler.pixelMode = 100;
		ruler.areaFactor = 0;
		ruler.title = "Double-click to change to next pixel scale.";
		legend.title = ruler.title;
		label.title = ruler.title;
		areaText.title = areaText.base + "\n\nAreas and path lengths are given in pixels.";
		break;
	case "96 pixels (48x2)":
		ruler.src = "Resources/Images/rulr96_48.png";
		legend.src = "Resources/Images/legd96.png";
		label.src = "Resources/Images/P96_48.png";
		//button.hOffset = ghOffset + 48;
		//buttonText.hOffset = ghOffset + 48;
		ruler.minW = 96;
		ruler.maxW = 1440;
		ruler.scaleFactor = 100;
		ruler.pixelMode = 100;
		ruler.areaFactor = 0;
		ruler.title = "Double-click to change to next pixel scale.";
		legend.title = ruler.title;
		label.title = ruler.title;
		areaText.title = areaText.base + "\n\nAreas and path lengths are given in pixels.";
		break;
	case "100 pixels (10x10)":
		ruler.src = "Resources/Images/rulr100_10.png";
		legend.src = "Resources/Images/legd100.png";
		label.src = "Resources/Images/P100_10.png";
		//button.hOffset = ghOffset + 50;
		//buttonText.hOffset = ghOffset + 50;
		ruler.minW = 100;
		ruler.maxW = 1500;
		ruler.scaleFactor = 100;
		ruler.pixelMode = 100;
		ruler.areaFactor = 0;
		ruler.title = "Double-click to change to next pixel scale.";
		legend.title = ruler.title;
		label.title = ruler.title;
		areaText.title = areaText.base + "\n\nAreas and path lengths are given in pixels.";
		break;
	case "100 pixels (50x2)":
		ruler.src = "Resources/Images/rulr100_50.png";
		legend.src = "Resources/Images/legd100.png";
		label.src = "Resources/Images/P100_50.png";
		//button.hOffset = ghOffset + 50;
		//buttonText.hOffset = ghOffset + 50;
		ruler.minW = 100;
		ruler.maxW = 1500;
		ruler.scaleFactor = 100;
		ruler.pixelMode = 100;
		ruler.areaFactor = 0;
		ruler.title = "Double-click to change to next pixel scale.";
		legend.title = ruler.title;
		label.title = ruler.title;
		areaText.title = areaText.base + "\n\nAreas and path lengths are given in pixels.";
		break;

	case "1 cm in mm":
		ruler.src = "Resources/Images/rulr40_10.png";
		legend.src = "Resources/Images/legd_cm.png";
		label.src = "Resources/Images/cm.png";
		//button.hOffset = ghOffset + 60;
		//buttonText.hOffset = ghOffset + 60;
		ruler.minW = 80;
		ruler.maxW = 1440;
		ruler.scaleFactor = 101.6;
		ruler.pixelMode = 0;
		ruler.areaFactor = 6.4516;
		ruler.title = "Double-click to change to first inch scale.";
		legend.title = ruler.title;
		label.title = ruler.title;
		areaText.title = areaText.base + "\n\nAreas are given in cm^2 and path lengths in cm.";
		break;
	case "1 inch in 32nds":
		ruler.src = "Resources/Images/rulr96_32.png";
		legend.src = "Resources/Images/legd96_inch.png";
		label.src = "Resources/Images/inch_32.png";
		//button.hOffset = ghOffset + 48;
		//buttonText.hOffset = ghOffset + 48;
		ruler.minW = 96;
		ruler.maxW = 1440;
		ruler.scaleFactor = 96;
		ruler.pixelMode = 0;
		ruler.areaFactor = 1;
		ruler.title = "Double-click to change to next inch scale.";
		legend.title = ruler.title;
		label.title = ruler.title;
		areaText.title = areaText.base + "\n\nAreas are given in inch^2 and path lengths in inches.";
		break;
	case "1 inch in 48ths":
		ruler.src = "Resources/Images/rulr96_48.png";
		legend.src = "Resources/Images/legd96_inch.png";
		label.src = "Resources/Images/inch_48.png";
		//button.hOffset = ghOffset + 48;
		//buttonText.hOffset = ghOffset + 48;
		ruler.minW = 96;
		ruler.maxW = 1440;
		ruler.scaleFactor = 96;
		ruler.pixelMode = 0;
		ruler.areaFactor = 1;
		ruler.title = "Double-click to change to next inch scale.";
		legend.title = ruler.title;
		label.title = ruler.title;
		areaText.title = areaText.base + "\n\nAreas are given in inch^2 and path lengths in inches.";
		break;
	case "1 inch in 10ths":
		ruler.src = "Resources/Images/rulr100_10.png";
		legend.src = "Resources/Images/legd100_inch.png";
		label.src = "Resources/Images/inch_10.png";
		//button.hOffset = ghOffset + 50;
		//buttonText.hOffset = ghOffset + 50;
		ruler.minW = 100;
		ruler.maxW = 1500;
		ruler.scaleFactor = 100;
		ruler.pixelMode = 0;
		ruler.areaFactor = 1;
		ruler.title = "Double-click to change to next inch scale.";
		legend.title = ruler.title;
		label.title = ruler.title;
		areaText.title = areaText.base + "\n\nAreas are given in inch^2 and path lengths in inches.";
		break;
	case "1 inch in 50ths":
		ruler.src = "Resources/Images/rulr100_50.png";
		legend.src = "Resources/Images/legd100_inch.png";
		label.src = "Resources/Images/inch_50.png";
		//button.hOffset = ghOffset + 50;
		//buttonText.hOffset = ghOffset + 50;
		ruler.minW = 100;
		ruler.maxW = 1500;
		ruler.scaleFactor = 100;
		ruler.pixelMode = 0;
		ruler.areaFactor = 1;
		ruler.title = "Double-click to change to centimeter scale.";
		legend.title = ruler.title;
		label.title = ruler.title;
		areaText.title = areaText.base + "\n\nAreas are given in inch^2 and path lengths in inches.";
		break;

	case "one-quarter-inch-to-the-foot (1:48)":
		ruler.src = "Resources/Images/rulr96_48.png";
		legend.src = "Resources/Images/legd_A_48.png";
		label.src = "Resources/Images/inch_1_48.png";
		//button.hOffset = ghOffset + 48;
		//buttonText.hOffset = ghOffset + 48;
		ruler.minW = 96;
		ruler.maxW = 1440;
		ruler.scaleFactor = 96;
		ruler.pixelMode = 0;
		ruler.areaFactor = 16;
		ruler.title = "Double-click to change to next architect's scale.";
		legend.title = ruler.title;
		label.title = ruler.title;
		areaText.title = areaText.base + "\n\nAreas are given in ft^2 and path lengths in ft.";
		break;
	case "three-sixteenths-inch-to-the-foot (1:64)":
		ruler.src = "Resources/Images/rulr96_32_18.png";
		legend.src = "Resources/Images/legd_A_64.png";
		label.src = "Resources/Images/inch_1_64.png";
		//button.hOffset = ghOffset + 48;
		//buttonText.hOffset = ghOffset + 48;
		ruler.minW = 90;
		ruler.maxW = 1440;
		ruler.scaleFactor = 96;
		ruler.pixelMode = 0;
		ruler.areaFactor = 256 / 9;
		ruler.title = "Double-click to change to next architect's scale.";
		legend.title = ruler.title;
		label.title = ruler.title;
		areaText.title = areaText.base + "\n\nAreas are given in ft^2 and path lengths in ft.";
		break;
	case "one-eighth-inch-to-the-foot (1:96)":
		ruler.src = "Resources/Images/rulr96_32.png";
		legend.src = "Resources/Images/legd_A_96.png";
		label.src = "Resources/Images/inch_1_96.png";
		//button.hOffset = ghOffset + 48;
		//buttonText.hOffset = ghOffset + 48;
		ruler.minW = 96;
		ruler.maxW = 1440;
		ruler.scaleFactor = 96;
		ruler.pixelMode = 0;
		ruler.areaFactor = 64;
		ruler.title = "Double-click to change to next architect's scale.";
		legend.title = ruler.title;
		label.title = ruler.title;
		areaText.title = areaText.base + "\n\nAreas are given in ft^2 and path lengths in ft.";
		break;
	case "three-thirty-seconds-inch-to-the-foot (1:128)":
		ruler.src = "Resources/Images/rulr96_32_9.png";
		legend.src = "Resources/Images/legd_A_128.png";
		label.src = "Resources/Images/inch_1_128.png";
		//button.hOffset = ghOffset + 48;
		//buttonText.hOffset = ghOffset + 48;
		ruler.minW = 90;
		ruler.maxW = 1440;
		ruler.scaleFactor = 96;
		ruler.pixelMode = 0;
		ruler.areaFactor = 1024 / 9;
		ruler.title = "Double-click to change to next architect's scale.";
		legend.title = ruler.title;
		label.title = ruler.title;
		areaText.title = areaText.base + "\n\nAreas are given in ft^2 and path lengths in ft.";
		break;

	default:
		setPreference("modePref", "100 pixels (10x10)");
		ruler.src = "Resources/Images/rulr100_10.png";
		legend.src = "Resources/Images/legd100.png";
		label.src = "Resources/Images/P100_10.png";
		//button.hOffset = ghOffset + 50;
		//buttonText.hOffset = ghOffset + 50;
		ruler.minW = 100;
		ruler.maxW = 1500;
		ruler.scaleFactor = 100;
		ruler.pixelMode = 100;
		ruler.areaFactor = 0;
		ruler.title = "Double-click to change to next pixel scale.";
		legend.title = ruler.title;
		label.title = ruler.title;
		areaText.title = areaText.base + "\n\nAreas and path lengths are given in pixels.";
	}
}

function doubleClicked() {
	let modePref;

	switch (getPreference("modePref")) {
	case "40 pixels (10x4)":
		modePref = "96 pixels (32x3)";
		break;
	case "96 pixels (32x3)":
		modePref = "96 pixels (48x2)";
		break;
	case "96 pixels (48x2)":
		modePref = "100 pixels (10x10)";
		break;
	case "100 pixels (10x10)":
		modePref = "100 pixels (50x2)";
		break;
	case "100 pixels (50x2)":
		modePref = "40 pixels (10x4)";
		break;

	case "1 cm in mm":
		modePref = "1 inch in 32nds";
		break;
	case "1 inch in 32nds":
		modePref = "1 inch in 48ths";
		break;
	case "1 inch in 48ths":
		modePref = "1 inch in 10ths";
		break;
	case "1 inch in 10ths":
		modePref = "1 inch in 50ths";
		break;
	case "1 inch in 50ths":
		modePref = "1 cm in mm";
		break;

	case "one-quarter-inch-to-the-foot (1:48)":
		modePref = "three-sixteenths-inch-to-the-foot (1:64)";
		break;
	case "three-sixteenths-inch-to-the-foot (1:64)":
		modePref = "one-eighth-inch-to-the-foot (1:96)";
		break;
	case "one-eighth-inch-to-the-foot (1:96)":
		modePref = "three-thirty-seconds-inch-to-the-foot (1:128)";
		break;
	case "three-thirty-seconds-inch-to-the-foot (1:128)":
		modePref = "one-quarter-inch-to-the-foot (1:48)";
		break;

	default:
		modePref = "100 pixels (10x10)";
	}

	setMode(modePref);
	setPreference("modePref", modePref);
	Menu[0].value = modePref;

	ruler.width = ruler.srcWidth * thePPI(ruler.rotation, ruler.ppiH, ruler.ppiV, ruler.pixelMode) / ruler.scaleFactor;
	legend.width = ruler.width;
}

////////////////////////////////////// Event Handlers ////////////////////////////////////

Menu[0].onchange = function () {
	setMode(Menu[0].value);
	setPreference("modePref", Menu[0].value);

	ruler.width = ruler.srcWidth * thePPI(ruler.rotation, ruler.ppiH, ruler.ppiV, ruler.pixelMode) / ruler.scaleFactor;
	legend.width = ruler.width;
};

ruler.ondblclick = function (event) {
	event.stopPropagation();
	event.preventDefault();

	doubleClicked();
};
legend.ondblclick = ruler.ondblclick;

////////////////////////////////////////// Exports ///////////////////////////////////////

export {setMode};
