/*
    Hex Display - A Hex Display Widget
    Copyright © 2008-2019 Harry Whitfield

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to the Free
	Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
	MA  02110-1301  USA

	Hex Display - version 1.0 for Hex Display Web widget
	14 October, 2019
	Copyright © 2008-2019 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*jslint browser, for */

/*property
    fromCharCode, length, toString, toUpperCase
*/

function makeHex(bytes, start, count) {
	var n;
	var extra;
	var lines;
	var ss;
	var line;
	var i;

	function printTextLine(i, k) {
		var s = "";
		var j;
		var c;

		for (j = 0; j < k; j += 1) {
			c = Number(bytes[16 * i + j + start]);
			if ((c > 31) && (c < 128)) {
				s += String.fromCharCode(c);
			} else {
				s += ".";
			}
		}
		return s;
	}

	function printLine(i) {
		var tmp = 16 * i + start;
		var addr = tmp.toString(16).toUpperCase();
		var s;
		var j;
		var hex;

		while (addr.length < 6) {
			addr = "0" + addr;
		}
		s = addr + ": ";
		for (j = 0; j < 16; j += 1) {
			hex = Number(bytes[16 * i + j + start]).toString(16).toUpperCase();
			if (hex.length < 2) {
				hex = "0" + hex;
			}
			s += hex + " ";
		}
		s += " ";
		s += printTextLine(i, 16);
		s += "\n";
		return s;
	}

	function printLastLine(i, extra) {
		var j;
		var addr;
		var s;
		var hex;
		var tmp;

		if (extra === 0) {
			return "";
		}
		tmp = 16 * i + start;
		addr = tmp.toString(16).toUpperCase();
		while (addr.length < 6) {
			addr = "0" + addr;
		}
		s = addr + ": ";
		for (j = 0; j < extra; j += 1) {
			hex = Number(bytes[16 * i + j + start]).toString(16).toUpperCase();
			if (hex.length < 2) {
				hex = "0" + hex;
			}
			s += hex + " ";
		}
		s += " ";
		if (extra !== 0) {
			for (j = extra; j < 16; j += 1) {
				s += "   ";
			}
		}
		s += printTextLine(i, extra);
		s += "\n";
		return s;
	}

	n = count;
	extra = n % 16;
	lines = (n - extra) / 16;
	ss = "";
	line = "";

	for (i = 0; i < lines; i += 1) {
		line = printLine(i);
		ss += line;
	}
	line = printLastLine(i, extra);
	ss += line;

	return ss;
}
