/*
	HexDeCoder - A hexadecimal/decimal/octal/binary converter.
	Copyright © 2004-2015 Harry Whitfield

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2 of the License, or (at your
	option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

	HexDeCoder - browser version 1.0
	28 April, 2015
	Copyright © 2004-2015 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*global recomputeData, updatePrefs */

/*properties
    PI, add, appendChild, backgroundColor, body, border, checked, clearRect,
    clientX, close, cols, createElement, ctx, div, drawImage, getContext,
    hOffset, hRegP, height, left, length, onclick, onmousedown, onmousemove,
    onmouseout, onmouseover, onmouseup, opacity, open, readonly, restore, rotate,
    round, rows, save, scale, selectedIndex, setAttribute, setStyle, size, src,
    style, text, title, top, tracking, translate, type, vRegP, value, width,
    zOrder, maxWidth
*/

//////////////////////////////////////////////////////////////////////////////////////////

var scale = 1.0, vtop = 0, left = 0, fScale = 6.6;	// was 6.67

var main_window = {width: Math.round(520 * scale), height: Math.round(318 * scale)},
	halfWidth   = Math.round(main_window.width  / 2),
	halfHeight  = Math.round(main_window.height / 2),
	
	radToDeg = 180 / Math.PI,
	degToRad = Math.PI / 180,
	rotToPc  = 100 / 360;

function newElement(tagName, hOffset, vOffset, zOrder) {
	var div = document.createElement("div"), ele;

	div.setAttribute("style", "position: absolute; left: " + String(hOffset + left) +
		"px; top: " + String(vOffset + vtop) + "px; z-index: " + String(zOrder) + ";");

	document.body.appendChild(div);
		
	ele = document.createElement(tagName);
	ele.left = hOffset;
	ele.top  = vOffset;
	ele.div = div;
	ele.zOrder = zOrder;
	div.appendChild(ele);

	return ele;
}

function moveImg(obj, hOffset, vOffset) {
	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);

	obj.div.setAttribute("style", "position: absolute; left: " + String(hOffset + left) +
		"px; top: " + String(vOffset + vtop) + "px; z-index: " + String(obj.zOrder) + ";");
}

function move(obj) {
	obj.div.setAttribute("style", "position: absolute; left: " + String(obj.left + left) +
		"px; top: " + String(obj.top + vtop) + "px; z-index: " + String(obj.zOrder) + ";");
}

function newImage(hOffset, vOffset, width, height, src, zOrder, opacity) {
	var img;

	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);
	
	img = newElement("img", hOffset, vOffset, zOrder);
	
	img.width  = Math.round(scale * width);
	img.height = Math.round(scale * height);
	img.src = src;
	img.style.opacity = opacity || 1.0;
	return img;
}

function newCanvas(hOffset, vOffset, width, height, src, zOrder, opacity, hRegP, vRegP) {
	var canvas;
	
	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);
	
	canvas = newElement("canvas", hOffset, vOffset, zOrder);

	hRegP = hRegP || 0;		// hRegP and vRegP are optional parameters
	vRegP = vRegP || 0;

	canvas.src = src;
	canvas.style.opacity = opacity || 1.0;
	
	canvas.width = Math.round(scale * width);
	canvas.height = Math.round(scale * height);
	canvas.ctx = canvas.getContext("2d");
	canvas.hRegP = Math.round(scale * hRegP);
	canvas.vRegP = Math.round(scale * vRegP);
	return canvas;
}

function newCanvasImage(canvas) {
	var img = new Image();
	
	img.width  = canvas.width;
	img.height = canvas.height;
	img.src    = canvas.src;
	return img;
}

function drawImage(canvas, img, hOff, vOff, ang) {
	var ctx = canvas.ctx, width = canvas.width, height = canvas.height,
		hRegP = canvas.hRegP, vRegP = canvas.vRegP;

	ctx.save();
	ctx.clearRect(0, 0, width, height);
	ctx.translate(hRegP, vRegP);
	ctx.rotate(Math.PI * ang / 180);
	ctx.translate(-hRegP, -vRegP);
	ctx.scale(scale, scale);
	ctx.drawImage(img, hOff, vOff);
	ctx.restore();
}
/*
function drawText(canvas, text, hOff, vOff, ang, font) {
	var ctx = canvas.ctx, width = canvas.width, height = canvas.height,
		hRegP = canvas.hRegP, vRegP = canvas.vRegP;
	
	ctx.save();
	ctx.clearRect(0, 0, width, height);
	ctx.translate(hRegP, vRegP);
	ctx.rotate(Math.PI * ang / 180);
	ctx.translate(-hRegP, -vRegP);
	ctx.scale(scale, scale);
	ctx.font = font;
	ctx.fillText(text, hOff, vOff); 
	ctx.restore();
}
*/

function newSelector(hOffset, vOffset, width, height, src, zOrder, opacity) {
	var selector;

	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);
	
	selector = newElement("select", hOffset, vOffset, zOrder);
	
	selector.width  = Math.round(scale * width);
	selector.height = Math.round(scale * height);
	selector.src = src;
	selector.style.opacity = opacity || 1.0;
	
//	selector.style.fontWeight = "bold";
//	selector.style.fontSize = "14px";
	
	return selector;
}

function addToMenu(selector, strings) {
	var i, option;

	for (i = 0; i < strings.length; i += 1) {
		option = document.createElement("option");
		option.text = strings[i];
		selector.add(option);
	}
}

function newInput(hOffset, vOffset, width, height, value, zOrder, opacity) {
	var input;

	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);
	
	input = newElement("input", hOffset, vOffset, zOrder);
	input.type = "text";
	
	input.width = Math.round(scale * width);
	input.size  = Math.round(scale * width / fScale);
	input.height = Math.round(scale * height);
	input.value = value;
	input.style.opacity = opacity || 1.0;
	return input;
}

function newTextArea(hOffset, vOffset, cols, rows, value, zOrder, readonly) {
	var textarea;

	hOffset = Math.round(scale * hOffset);
	vOffset = Math.round(scale * vOffset);
	
	textarea = newElement("textarea", hOffset, vOffset, zOrder);
	
	textarea.cols  = cols;
	textarea.rows  = rows;
	textarea.value = value;
	textarea.readonly = readonly;

	return textarea;
}

//////////////////////////////////////////////////////////////////////////////////////////

var base, leftTop, leftMid, leftLow, middleTop, middleMid, middleLow,
	rightTop, rightMid, rightLow, dragbox, redButton, amberButton, greenButton, title,
	leftBgOne, midBgOne, rightBgOne, leftBgTwo, midBgTwo, rightBgTwo,
	leftBgThree, midBgThree, rightBgThree, leftBgFour, midBgFour, rightBgFour,
	paramOne, paramTwo, paramThree, paramFour,
	headingOne, headingTwo, headingThree, headingFour, helpButton, font,
	ipClass, bitNumbers, byteMarks,
	fullFrameBox, fullFrameButton, deciFrameBox, deciFrameButton,
	rightJustifyBox, rightJustifyButton, bitMarkersBox, bitMarkersButton;

(function () {
//	mainWindow.width  = Math.round(scale * 280);
//	mainWindow.height = Math.round(scale * 318);

// newImage(hOffset, vOffset, width, height, src, zOrder, opacity) {
// newInput(hOffset, vOffset, size, height, value, zOrder, opacity) {
// newTextArea(hOffset, vOffset, cols, rows, value, zOrder, readonly) {
// newCanvas(hOffset, vOffset, width, height, src, zOrder, opacity, hRegP, vRegP)	

	base = "Resources/bkgd/";

	leftTop   = newImage(0,     0,  40,  40, base + "bgleftTop.png",     1);
	leftMid	  = newImage(0,    40,  40, 225, base + "bgleftMid.png",     1);
	leftLow	  = newImage(0,   265,  40,  53, base + "bgleftLow.png",     1);
	
	middleTop = newImage(40,    0, 200,  40, base + "bgmiddleTop.png",   1);
	middleMid = newImage(40,   40, 200, 225, base + "bgmiddleMid.png",   1);
	middleLow = newImage(40,  265, 200,  53, base + "bgmiddleLow.png",   1);
	
	rightTop  = newImage(240,   0,  40,  40, base + "bgrightTop.png",    1);
	rightMid  = newImage(240,  40,  40, 225, base + "bgrightMid.png",    1);
	rightLow  = newImage(240, 265,  40,  53, base + "bgrightLow.png",    1);
	
	dragbox   = newImage(238, 271,  20,  20, base + "dragbox.png",       2);
	dragbox.tracking = "rectangle";
	dragbox.title = "Click to enable - move over me to change the widget's width - click again to disable.";
	
	base = "Resources/buttons/";

	redButton   = newImage(28,     21, 21,  14, base + "red.png",          2);
	amberButton = newImage(49,     21, 21,  14, base + "amberMinus.png",   2);	// customized
	greenButton = newImage(70,     21, 14,  14, base + "green.png",        2);
	
	helpButton  = newImage(330,    16, 30,  22, base + "help.png",         3);	// customized

	redButton.title   = "Close the Widget.";
	amberButton.title = "Decimal numbers are signed. Click to use unsigned decimal numbers.";
	greenButton.title = "Toggle the window size.";
	
	helpButton.title  = "Displays information about this program.";
	
	title = newInput(88, 18, 80, 16, "HexDeCoder", 2);	// customized
	title.style.backgroundColor = "transparent";
	title.style.border = "none";

	base = "Resources/boxes/";

	leftBgOne    = newImage(28,  44,  18, 39, base + "tbleft.png", 2);
	midBgOne     = newImage(46,  44, 188, 39, base + "tbmiddle.png", 2);
	rightBgOne   = newImage(234, 44,  18, 39, base + "tbright.png", 2);
	
	leftBgTwo    = newImage(28,  100,  18, 39, base + "tbleft.png", 2);
	midBgTwo     = newImage(46,  100, 188, 39, base + "tbmiddle.png", 2);
	rightBgTwo   = newImage(234, 100,  18, 39, base + "tbright.png", 2);
	
	leftBgThree  = newImage(28,  156,  18, 39, base + "tbleft.png", 2);
	midBgThree   = newImage(46,  156, 188, 39, base + "tbmiddle.png", 2);
	rightBgThree = newImage(234, 156,  18, 39, base + "tbright.png", 2);
	
	leftBgFour   = newImage(28,  212,  18, 39, base + "tbleft.png", 2);
	midBgFour    = newImage(46,  212, 188, 39, base + "tbmiddle.png", 2);
	rightBgFour  = newImage(234, 212,  18, 39, base + "tbright.png", 2);
	
	paramOne     = newInput(37,   53,  200, 20, "", 3);
	paramTwo     = newInput(37,  109,  200, 20, "", 3);
	paramThree   = newInput(37,  165,  200, 20, "", 3);
	paramFour    = newInput(37,  221,  200, 20, "", 3);
	
	//paramOne.style.background = "rgba(192 ,192, 192, 1.0)";

	paramOne.title   = "Enter a hexadecimal number in this box.";	// customized
	paramTwo.title   = "Enter a decimal number in this box.";		// customized
	paramThree.title = "Enter an octal number in this box.";		// customized
	paramFour.title  = "Enter a binary number in this box.";		// customized

	font = 'font-family:Courier;font-weight:bold;font-size:11px';

	paramOne.style.setStyle(font);
	paramTwo.style.setStyle(font);
	paramThree.style.setStyle(font);
	paramFour.style.setStyle(font);

	paramOne.style.border    = "none";
	paramTwo.style.border    = "none";
	paramThree.style.border  = "none";
	paramFour.style.border   = "none";

	headingOne   = newInput(37,  72, 20, 16, "16",  2);	// customized
	headingTwo   = newInput(37, 128, 20, 16, "10",  2);	// customized
	headingThree = newInput(37, 184, 20, 16, "8",   2);	// customized
	headingFour  = newInput(37, 240, 20, 16, "2",   3);	// customized
	
	headingOne.style.backgroundColor   = "transparent";
	headingTwo.style.backgroundColor   = "transparent";
	headingThree.style.backgroundColor = "transparent";
	headingFour.style.backgroundColor  = "transparent";
	
	headingOne.style.border   = "none";
	headingTwo.style.border   = "none";
	headingThree.style.border = "none";
	headingFour.style.border  = "none";
	
	ipClass    = newInput(37, 142, 160, 20, "25252525252", 4);
	bitNumbers = newInput(39, 198, 127, 20, "0123456789012345678901234567890123456789012345678901234567890123",  2);
	byteMarks  = newInput(39, 243, 127, 20, "|0     7|8    15|16   23|24   31|32   39|40   47|48   55|56   63|", 2);
	
	ipClass.style.setStyle(font);
	bitNumbers.style.setStyle(font);
	byteMarks.style.setStyle(font);
	
	ipClass.style.opacity    = 0.0;
	bitNumbers.style.opacity = 0.0;
	byteMarks.style.opacity  = 0.0;
	
	bitNumbers.style.backgroundColor = "transparent";
	byteMarks.style.backgroundColor  = "transparent";
	
	bitNumbers.style.border = "none";
	byteMarks.style.border  = "none";

	fullFrameBox = newInput(118,  77, 20, 16, "full-frames",  2);	// was 115
	fullFrameBox.setAttribute("type", "checkbox");
	fullFrameButton = newInput(37, 77, 20, 16, "full-frames", 2);
	fullFrameButton.setAttribute("type", "button");
	fullFrameButton.onclick = function () {
		fullFrameBox.checked = !fullFrameBox.checked;
		updatePrefs();
	};
	fullFrameBox.title = "Check this box if you wish non-decimal numbers to be displayed full frame.";

	deciFrameBox = newInput(225,  77, 20, 16, "dec-frames",   2);
	deciFrameBox.setAttribute("type", "checkbox");
	deciFrameButton = newInput(140, 77, 20, 16, "dec-frames", 2);	// 135
	deciFrameButton.setAttribute("type", "button");
	deciFrameButton.onclick = function () {
		deciFrameBox.checked = !deciFrameBox.checked;
		updatePrefs();
	};
	deciFrameBox.title = "Check this box if you wish decimal numbers to be displayed full frame.";

	rightJustifyBox = newInput(332,  77, 20, 16, "right-justify",   2);
	rightJustifyBox.setAttribute("type", "checkbox");
	rightJustifyButton = newInput(246, 77, 20, 16, "right-justify", 2);
	rightJustifyButton.setAttribute("type", "button");
	rightJustifyButton.onclick = function () {
		rightJustifyBox.checked = !rightJustifyBox.checked;
		updatePrefs();
	};
	rightJustifyBox.title = "Check this box if you wish the ouput of numbers to be right justified.";

	bitMarkersBox = newInput(440,  77, 20, 16, "bit-markers",  2);
	bitMarkersBox.setAttribute("type", "checkbox");
	bitMarkersButton = newInput(354, 77, 20, 16, "bit-markers", 2);
	bitMarkersButton.setAttribute("type", "button");
	bitMarkersButton.onclick = function () {
		bitMarkersBox.checked = !bitMarkersBox.checked;
		updatePrefs();
	};
	bitMarkersBox.title = "Check this box if you wish to have the bit positions of binary numbers displayed.";
	
}());

//////////////////////////////////// Menus Customized ////////////////////////////////////

var MenuArray = [
	['16-bit', '32-bit', '64-bit'],
	['IP-v4', 'UTF-8', 'UTF-16', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18',
		'19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31', '32', '33', '34', '35', '36'],
	['big-endian', 'little-endian']
];

var MenuTitleArray = [
	"Choose the Word Length.",
	"Choose the Custom Base.",
	"Choose the Bit Numbering."
];

var MenuSelectedIndex = [2, 9, 0];

var Menu = [];

Menu[0] = newSelector(175, 17, 110, 20, "", 2);
Menu[1] = newSelector(250, 17, 110, 20, "", 2);
Menu[2] = newSelector(333, 17, 110, 20, "", 2);

var i;

for (i = 0; i < MenuArray.length; i += 1) {
	addToMenu(Menu[i],  MenuArray[i]);
	Menu[i].selectedIndex = MenuSelectedIndex[i];
	Menu[i].title = MenuTitleArray[i];
}

//////////////////////////////////////////////////////////////////////////////////////////

var minWidth = 390;		// customized
var maxWidth = 530;		// customized
var curWidth  = maxWidth;
var debug = false;
var signedDecimal = false;
var dragEnabled = false;

var print = function (s) { alert(s); };

//////////////////////////////////////////////////////////////////////////////////////////

function setUp(width) {
	if (debug) {
		print('setUp():======== start ========:');
		print('width=' + width);
		print('minWidth=' + minWidth);
		print('maxWidth=' + maxWidth);
	}

	if (width < minWidth) {
		width = minWidth;
	}
	if (width > maxWidth) {
		width = maxWidth;
	}

	main_window.width = width;
	
	middleTop.width  =
		middleMid.width  =
		middleLow.width  = width - 80;

	rightTop.hOffset = width - 40;
	moveImg(rightTop, width - 40,   0);
	moveImg(rightMid, width - 40,  40);
	moveImg(rightLow, width - 40, 265);

	midBgOne.width =
		midBgTwo.width =
		midBgThree.width  =
		midBgFour.width   = width - 92;

	moveImg(rightBgOne,   width - 46,  44);
	moveImg(rightBgTwo,   width - 46, 100);
	moveImg(rightBgThree, width - 46, 156);
	moveImg(rightBgFour,  width - 46, 212);

	dragbox.hOffset = width - 42;
	moveImg(dragbox,  width - 42,     271);
	
	helpButton.hOffset = width - 60;
	moveImg(helpButton,  width - 60,   16);

	paramOne.width =
		paramTwo.width =
		paramThree.width =
		paramFour.width = Math.round(scale * (width - 84));

	paramOne.size =
		paramTwo.size =
		paramThree.size =
		paramFour.size = Math.round(scale * (width - 84) / fScale);

	paramOne.style.maxWidth =
		paramTwo.style.maxWidth =
		paramThree.style.maxWidth =
		paramFour.style.maxWidth = Math.round(scale * (width - 84)) + "px";

	headingOne.hOffset =
		headingTwo.hOffset =
		headingThree.hOffset =
		headingFour.hOffset  = width - 60;
	
	moveImg(headingOne,   width - 46,  72);
	moveImg(headingTwo,   width - 46, 128);
	moveImg(headingThree, width - 46, 184);
	moveImg(headingFour,  width - 46, 240);

	bitNumbers.width = 
    	byteMarks.width  = Math.round(scale * (width - 84));
  
  	bitNumbers.size =
		byteMarks.size = Math.round(scale * (width - 84) / fScale);
		
	bitNumbers.style.maxWidth =
		byteMarks.style.maxWidth  = Math.round(scale * (width - 84)) + "px";

	Menu[2].style.opacity = width === maxWidth ? 1.0 : 0.0;
	bitMarkersBox.style.opacity = width === maxWidth ? 1.0 : 0.0;
	bitMarkersButton.style.opacity = width === maxWidth ? 1.0 : 0.0;

	if (debug) {
		print('width=' + width);

		print('main_window.width=' + main_window.width);
		print('middleTop.width='   + middleTop.width);
		print('rightTop.hOffset='  + rightTop.hOffset);
		print('paramOne.width='   + paramOne.width);
		print('dragbox.hOffset='  + dragbox.hOffset);

		print('setUp():========  end  ========:');
	}

	return width;
}

//////////////////////////////////////////////////////////////////////////////////////////

dragbox.onclick = function () {
	dragEnabled = !dragEnabled;
	if (dragEnabled) {
		Menu[2].style.opacity = 0.0;
		helpButton.style.opacity = 0.0;
		bitMarkersBox.style.opacity = 0.0;
		bitMarkersButton.style.opacity = 0.0;
		
	} else {
		if (curWidth === maxWidth) {
			Menu[2].style.opacity = 1.0;
			helpButton.style.opacity = 1.0;
			bitMarkersBox.style.opacity = 1.0;
			bitMarkersButton.style.opacity = 1.0;
		} else if (curWidth === minWidth) {
			helpButton.style.opacity = 1.0;
		}
	}
};

dragbox.onmousemove = function (event) {
	if (dragEnabled) {
		moveImg(dragbox, event.clientX - 10, 271);
		curWidth = setUp(event.clientX - 10 + 42);
	}
};

function setAmber(signed) {
 	var base = "Resources/buttons/";
	
	if (signed) {
        amberButton.src = base + "amberMinus.png";
    } else {
        amberButton.src = base + "amber.png";
    }
}

function normalButtons() {
	var base = "Resources/buttons/";
	
	redButton.src   = base + "red.png";
//	amberButton.src = base + "amber.png";
	greenButton.src = base + "green.png";
    setAmber(signedDecimal);
}

function activeButtons() {
	var base = "Resources/buttons/";
	
	redButton.src   = base + "redCross.png";
//	amberButton.src = base + "amberMinus.png";
	greenButton.src = base + "greenPlus.png";
    setAmber(signedDecimal);
}

function setTooltips(signed) {
    if (signed) {
        amberButton.title = "Decimal numbers are signed. Click to use unsigned decimal numbers.";
    } else {
        amberButton.title = "Decimal numbers are unsigned. Click to use signed decimal numbers.";
    }
}

function clearData() {
	paramOne.value =
		paramTwo.value =
		paramThree.value =
		paramFour.value = "";
}

redButton.onmouseover = function () {
	activeButtons();
};

redButton.onmouseout = function () {
	normalButtons();
};

amberButton.onmouseover = function () {
	activeButtons();
};

amberButton.onmouseout = function () {
	normalButtons();
};

function toggleDecimalMode() {
    signedDecimal = !signedDecimal;
    setTooltips(signedDecimal);
	recomputeData();
}

amberButton.onclick = function () {
    toggleDecimalMode();
    setAmber(signedDecimal);
};


greenButton.onmouseover = function () {
	activeButtons();
};

greenButton.onmouseout = function () {
	normalButtons();
};

redButton.onclick = function () {
	window.close();
};

greenButton.onclick = function () {
	dragEnabled = false;
	
	if (curWidth === minWidth) {
		curWidth = setUp(maxWidth);
		Menu[2].style.opacity = 1.0;
		bitMarkersBox.style.opacity = 1.0;
		bitMarkersButton.style.opacity = 1.0;
	} else {
		curWidth = setUp(minWidth);
		Menu[2].style.opacity = 0.0;
		bitMarkersBox.style.opacity = 0.0;
		bitMarkersButton.style.opacity = 0.0;
	}
	helpButton.style.opacity = 1.0;
};

helpButton.onmousedown = function () { this.style.opacity = "0.5"; };
helpButton.onmouseup   = function () { this.style.opacity = "1.0"; window.open("Help.html"); };

setUp(maxWidth);
