/*
	Factors
 	Copyright © 2022-2023 Harry Whitfield

 	This program is free software; you can redistribute it and/or modify it
 	under the terms of the GNU General Public License as published by the
 	Free Software Foundation; either version 2 of the License, or (at your
 	option) any later version.

 	This program is distributed in the hope that it will be useful, but
 	WITHOUT ANY WARRANTY; without even the implied warranty of
 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 	General Public License for more details.

 	You should have received a copy of the GNU General Public License along
 	with this program; if not, write to the Free Software Foundation, Inc.,
 	51 Franklin St, Fifth Floor, Boston, MA	 02110-1301	 USA

 	Factors - browser version 1.0.2
 	14 March, 2023
 	Copyright © 2022-2023 Harry Whitfield
 	mailto:g6auc@arrl.net
*/

/*jslint browser */

/*property
    appendChild, body, click, createElement, display, download, href,
    removeChild, replace, style, substring, toISOString, writeFile
*/

var filesystem = {};
var theLogText = "";

function isoTime() {
	var temp = new Date().toISOString().replace(/\D/g, "").substring(0, 14);
	var date = temp.substring(0, 8);
	var time = temp.substring(8);

	return date + "T" + time + "Z";
}

function eprint(theString) {
	theLogText += theString + "\n";
}

function lprint(theString) {
	theLogText += isoTime() + ": " + theString + "\n";
}

filesystem.writeFile = function (filename, text) {
  	var element = document.createElement("a");

  	element.href = "data:text/plain;charset=utf-8," + encodeURIComponent(text);
  	element.download = filename;
  	element.style.display = "none";
  	document.body.appendChild(element);
  	element.click();
  	document.body.removeChild(element);
};

function writeLogFile() {
	lprint("Factors log file saved.");
	filesystem.writeFile("Factors_" + isoTime() + ".txt", theLogText);
}
