/*
 	Coil Inductance - A Coil Inductance Calculator
 	Copyright © 2012,2015 Harry Whitfield

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2 of the License, or (at your
	option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

	Coil Inductance - browser version 1.0
	27 April, 2015
	opyright © 2012,2015 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*global paramOne, paramTwo, paramThree, paramFour,
	headingOne, headingTwo, headingThree, headingFour, clearData, Menu
*/

/*properties
    background, keyCode, onchange, onkeypress, round, selectedIndex, sqrt, style,
    title, toFixed, value, which
*/

// map custom names onto model names
var variable1 = paramOne;
var variable2 = paramTwo;
var variable3 = paramThree;
var variable4 = paramFour;

var variable1Heading = headingOne;
var variable2Heading = headingTwo;
var variable3Heading = headingThree;
var variable4Heading = headingFour;

var outputModeMenu = Menu[0];
var iModeMenu      = Menu[1];

var mode     = 0;	// Coil Diameter
var iMode    = 0;	// inches

var modeText = ['Coil Diameter', 'Number of Turns', 'Length of Coil', 'Coil Inductance'];
var unitText = ["inches", "millimeters"];

var modeValue = 0;
var oldModeValue = 0;
var iModeValue = 0;

var multiplier;

function parseNonNegFloat(s) {
    var v = parseFloat(s);
    if (isNaN(v)) {
        return v;
    }
    if (v >= 0) {
        return v;
    }
    return NaN;
}

function process() {
    var D, N, l,  L, result;

    function inductance(D, N, l) {
        return (N * N * D * D) / (18 * D + 40 * l);
    }

    function length(D, N, L) {
        return (D * D * N * N - 18 * D * L) / (40 * L);
    }

    function turns(D, l, L) {
        return Math.sqrt((18 * D + 40 * l) * L / (D * D));
    }
    
    function diameter(N, l, L) {
        return (18 * L + Math.sqrt(324 * L * L + 160 * N * N * l * L)) / (2 * N * N);
    }

    switch (mode) { // L=8, l=4, N=2, D=1
    case 3:
        D = multiplier * parseNonNegFloat(variable1.value);
        N = parseNonNegFloat(variable2.value);
        l = multiplier * parseNonNegFloat(variable3.value);
        result = inductance(D, N, l);
        //print('result: ' + result);
        if (isNaN(result)) {
            variable4.value = 'Invalid Input';
        } else {
        	variable4.value = result.toFixed(3);
        }
        break;

    case 2:
        D = multiplier * parseNonNegFloat(variable1.value);
        N = parseNonNegFloat(variable2.value);
        L = parseNonNegFloat(variable4.value);
        result = length(D, N, L) / multiplier;
        //print('result: ' + result);
        if (isNaN(result)) {
            variable3.value = 'Invalid Input';
        } else {
        	variable3.value = result.toFixed(3);
    	}
        break;

    case 1:
        D = multiplier * parseNonNegFloat(variable1.value);
        l = multiplier * parseNonNegFloat(variable3.value);
        L = parseNonNegFloat(variable4.value);
        result = turns(D, l, L);
        //print('result: ' + result);
        if (isNaN(result)) {
            variable2.value = 'Invalid Input';
        } else {
        	variable2.value = Math.round(result);
    	}
        break;

    case 0:
        N = parseNonNegFloat(variable2.value);
        l = multiplier * parseNonNegFloat(variable3.value);
        L = parseNonNegFloat(variable4.value);
        result = diameter(N, l, L) / multiplier;
        //print('result: ' + result);
        if (isNaN(result)) {
            variable1.value = 'Invalid Input';
        } else {
        	variable1.value = result.toFixed(3);
        }
        break;

    default:
        break;
    }
}

function updatePrefs() {
	var unitsText = "";
   
	mode  = modeValue;
	iMode = iModeValue;
    
    unitsText = iMode === 0 ? " (in inches)." : " (in millimeters).";
    multiplier = iMode === 0 ? 1 : 1 / 25.4;

    variable1Heading.value = modeText[0] + unitsText;
    variable2Heading.value = modeText[1];
    variable3Heading.value = modeText[2] + unitsText;
    variable4Heading.value = modeText[3] + " (in µH).";
    
	variable1.title = "Enter the coil diameter" + unitsText;
	variable2.title = "Enter the number of turns.";
	variable3.title = "Enter the length of the coil" + unitsText;
	variable4.title = "Enter the inductance (in µH).";
}

outputModeMenu.onchange  = function () {
	modeValue = this.selectedIndex;
	switch (oldModeValue) {
	case 0:
		variable1.style.background = "rgba(255, 255, 255, 1.0)";
		break;
	case 1:
		variable2.style.background = "rgba(255, 255, 255, 1.0)";
		break;
	case 2:
		variable3.style.background = "rgba(255, 255, 255, 1.0)";
		break;
	case 3:
		variable4.style.background = "rgba(255, 255, 255, 1.0)";
		break;
	}

	switch (modeValue) {
	case 0:
		variable1.style.background = "rgba(192, 192, 192, 1.0)";
		break;
	case 1:
		variable2.style.background = "rgba(192, 192, 192, 1.0)";
		break;
	case 2:
		variable3.style.background = "rgba(192, 192, 192, 1.0)";
		break;
	case 3:
		variable4.style.background = "rgba(192, 192, 192, 1.0)";
		break;
	}
	
	oldModeValue = modeValue;
	updatePrefs();
};

iModeMenu.onchange  = function () {
	iModeValue = this.selectedIndex;
	updatePrefs();
};

variable1.onkeypress = function (event) {
	var x = event.which || event.keyCode;
	
	if (x === 13) { process(); }
};

variable2.onkeypress = function (event) {
	var x = event.which || event.keyCode;
	
	if (x === 13) { process(); }
};

variable3.onkeypress = function (event) {
	var x = event.which || event.keyCode;
	
	if (x === 13) { process(); }
};

variable4.onkeypress = function (event) {
	var x = event.which || event.keyCode;
	
	if (x === 13) { process(); }
};

//updatePrefs();
